/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.commands;

import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.common.ui.dialogs.ProgressMonitorDialogWithTitle;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.form.model.Form;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.ui.util.OpenHelper;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.commands.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.BslDocumentMapper;
import com.e1c.langtool.v8.dt.ui.IFindSourceMdObjectHelper;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OpenSourceBslEditorHandler
extends AbstractHandler {
    @Inject
    private IExternalPropertyManagerRegistry propertyManagerRegistry;
    @Inject
    private IFindSourceMdObjectHelper findSourceObjectHelper;
    @Inject
    private OpenHelper openHelper;
    @Inject
    private IBmModelManager bmModelManager;
    private final BslDocumentMapper documentMapper = new BslDocumentMapper();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Module module;
        IEditorPart activeEditor;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITextSelection && (activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event)) != null && (module = OpenSourceBslEditorHandler.getEditorBslModule(activeEditor)) != null) {
            try {
                new ProgressMonitorDialogWithTitle(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.OpenSourceBslEditorHandler_Searching_for_source_module).run(false, false, monitor -> this.searchingForSourceModule(module, activeEditor));
            }
            catch (OperationCanceledException e) {
                BslPlugin.logInfo(Messages.OpenSourceBslEditorHandler_Searching_is_cancelled);
            }
            catch (InterruptedException | InvocationTargetException e) {
                BslPlugin.logError(e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void searchingForSourceModule(Module module, IEditorPart activeEditor) {
        EObject container = module.getOwner();
        MdObject translatedMdObject = null;
        EObject eObject = container;
        if (eObject instanceof Form) {
            void form;
            Form form2 = (Form)eObject;
            Form cfr_ignored_0 = (Form)eObject;
            translatedMdObject = form.getMdForm();
        } else if (container instanceof MdObject) {
            translatedMdObject = (MdObject)container;
        }
        MdObject sourceObject = this.findSourceObjectHelper.findSourceMdObject(translatedMdObject);
        if (sourceObject != null) {
            EReference eref = this.propertyManagerRegistry.getExternalPropertyManager(this.bmModelManager.getModel((EObject)translatedMdObject)).getReference((EObject)module);
            IEditorPart targetEditor = this.openHelper.openEditor((EObject)sourceObject, (EStructuralFeature)eref);
            if (targetEditor != null) {
                this.setComparablePostition(activeEditor, targetEditor);
            }
        } else {
            BslPlugin.logInfo(Messages.OpenSourceBslEditorHandler_Source_object_not_found);
        }
    }

    private static Module getEditorBslModule(IEditorPart editor) {
        XtextEditor xtextEditor = OpenSourceBslEditorHandler.getEditor((IWorkbenchPart)editor);
        if (xtextEditor != null) {
            return (Module)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource resource) throws Exception {
                    if (resource != null && !resource.getContents().isEmpty()) {
                        return (EObject)resource.getContents().get(0);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    private static XtextEditor getEditor(IWorkbenchPart part) {
        String extension;
        IResource resource;
        XtextEditor xtextEditor = part instanceof XtextEditor ? (XtextEditor)part : (XtextEditor)part.getAdapter(XtextEditor.class);
        if (xtextEditor != null && (resource = (IResource)xtextEditor.getEditorInput().getAdapter(IResource.class)) != null && (extension = resource.getFileExtension()) != null && "bsl".equalsIgnoreCase(extension)) {
            return xtextEditor;
        }
        return null;
    }

    private ISourceViewer getSourceViewer(IEditorPart editorPart) {
        return (ISourceViewer)editorPart.getAdapter(ITextOperationTarget.class);
    }

    private void setComparablePostition(IEditorPart sourceEditor, IEditorPart targetEditor) {
        ISourceViewer targetViewer;
        IDocument sourceDocument = null;
        IDocument targetDocument = null;
        ISourceViewer sourceViewer = this.getSourceViewer(sourceEditor);
        if (sourceViewer != null) {
            sourceDocument = sourceViewer.getDocument();
        }
        if ((targetViewer = this.getSourceViewer(targetEditor)) != null) {
            targetDocument = targetViewer.getDocument();
        }
        if (sourceDocument != null && targetDocument != null) {
            this.documentMapper.updateMapping(sourceDocument, targetDocument, (IProgressMonitor)new NullProgressMonitor());
        }
        int topLineNumber = sourceViewer.getTopIndex();
        int visibleLineCount = sourceViewer.getBottomIndex() - topLineNumber + 1;
        int matchingTopLineIndex = this.documentMapper.getMatchingTopLine(true, topLineNumber, visibleLineCount);
        targetViewer.setTopIndex(matchingTopLineIndex);
    }
}

