/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.properties;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.v8.dt.bsl.BslPreferences;
import com.e1c.langtool.v8.dt.bsl.CollectorProperties;
import com.e1c.langtool.v8.dt.bsl.translator.TranslatorProperties;
import com.e1c.langtool.v8.dt.bsl.translator.VariableDuplicatesResolveLevel;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.properties.Messages;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class BslPropertyPage
extends PropertyPage {
    private static final VariableDuplicatesResolveLevel DEFAULT_VARIABLE_DUPLICATE_RESOLVE_LEVEL = VariableDuplicatesResolveLevel.CHECK_KEYWORDS;
    private static final int TEXT_FIELD_WIDTH = 5;
    @Inject
    private BslPreferences bslPreferences;
    private Map<String, Button> buttons = Maps.newHashMap();
    private Text beforeField;
    private Text afterField;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addTranslatorSection(composite);
        this.addCollectSection(composite);
        this.addExtendedOptionsSection(composite);
        return composite;
    }

    private void addTranslatorSection(Composite parent) {
        Group groupCheckBoxes = new Group(parent, 16);
        groupCheckBoxes.setText(Messages.BslPropertyPage_If_translation_not_set);
        groupCheckBoxes.setLayout((Layout)new GridLayout(1, false));
        groupCheckBoxes.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = this.createDefaultComposite((Composite)groupCheckBoxes);
        TranslatorProperties prop = this.bslPreferences.getTranslatorProperties(this.getCurrentProject());
        this.createButton(composite, Messages.BslPropertyPage_Mask_implicit_variables_to_Var_N, "maskImplicitVariables", prop.maskImplicitVariables());
        this.createButton(composite, Messages.BslPropertyPage_Clear_comments_for_lines_of_code, "clearCodeComments", prop.clearCodeComments());
        this.createButton(composite, Messages.BslPropertyPage_Clear_descriptions_in_methods_documentary_comments, "clearMethodDescriptions", prop.clearMethodDescriptions());
        this.createButton(composite, Messages.BslPropertyPage_String_literal_lines_full_translation_stored_is_priority, "stringLiteralLinesFullTranslationStoredPriority", prop.isStringLiteralLinesFullTranslationStoredPriority());
        this.createButton(composite, Messages.BslPropertyPage_Compute_QueryResultSelection_properties, "computeQueryResult", prop.isComputeQueryResult());
        Group container = new Group(parent, 16);
        container.setText(Messages.BslPropertyPage_ConflictingVariableTranslation);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        Button radio = new Button((Composite)container, 16);
        radio.setText(Messages.BslPropertyPage_Do_not_check);
        this.setSelection(radio, prop.getCheckVariableDuplicatesResolveLevel(), VariableDuplicatesResolveLevel.DO_NOT_CHECK);
        this.buttons.put(VariableDuplicatesResolveLevel.DO_NOT_CHECK.getLevelName(), radio);
        radio = new Button((Composite)container, 16);
        radio.setText(Messages.BslPropertyPage_Check_dual_properties);
        this.setSelection(radio, prop.getCheckVariableDuplicatesResolveLevel(), VariableDuplicatesResolveLevel.CHECK_KEYWORDS);
        this.buttons.put(VariableDuplicatesResolveLevel.CHECK_KEYWORDS.getLevelName(), radio);
        radio = new Button((Composite)container, 16);
        radio.setText(Messages.BslPropertyPage_Check_all_properties);
        this.setSelection(radio, prop.getCheckVariableDuplicatesResolveLevel(), VariableDuplicatesResolveLevel.CHECK_ALL_PROPERTIES);
        this.buttons.put(VariableDuplicatesResolveLevel.CHECK_ALL_PROPERTIES.getLevelName(), radio);
    }

    private void addExtendedOptionsSection(Composite parent) {
        Group groupCheckBoxes = new Group(parent, 16);
        groupCheckBoxes.setText(Messages.BslPropertyPage_Extended_bsl_options);
        groupCheckBoxes.setLayout((Layout)new GridLayout(1, false));
        groupCheckBoxes.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = this.createDefaultComposite((Composite)groupCheckBoxes);
        TranslatorProperties translatorProperties = this.bslPreferences.getTranslatorProperties(this.getCurrentProject());
        this.createButton(composite, Messages.BslPropertyPage_Enable_tag_part_in_doc_comment, "enableTagsInDocComment", translatorProperties.isEnableTagPartInDocComment());
        this.createButton(composite, Messages.BslPropertyPage_Enable_extended_nstr_feature_keys, "enableExtendedNStrFeatureKeys", translatorProperties.isEnableExtendedNStrFeatureKeys());
        this.createButton(composite, Messages.BslPropertyPage_Alphabetical_order_of_languages_in_NStr, "alphabeticalLanguageOrderInNStr", translatorProperties.isAlphabeticalLanguageOrderInNStr());
        this.createButton(composite, Messages.BslPropertyPage_Replace_unknown_types_in_documentation_comment, "replaceUnknownTypesInDocumentationComment", translatorProperties.isReplaceUnknownTypesInDocumentationComment());
    }

    private void addCollectSection(Composite parent) {
        Group groupCheckBoxes = new Group(parent, 16);
        groupCheckBoxes.setText(Messages.BslPropertyPage_Collect_options);
        groupCheckBoxes.setLayout((Layout)new GridLayout(1, false));
        groupCheckBoxes.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = this.createDefaultComposite((Composite)groupCheckBoxes);
        CollectorProperties prop = this.bslPreferences.getCollectorProperties(this.getCurrentProject());
        Pair<Button, Label> buttonPair = this.createButton(composite, Messages.BslPropertyPage_Collect_code_context_arround_NStr, "collectNstrCodeContext", prop.collectNstrCodeContext());
        Composite fields = this.createDefaultComposite((Composite)groupCheckBoxes);
        Label beforeLabel = new Label(fields, 0);
        beforeLabel.setText(Messages.BslPropertyPage_Lines_of_code_before_NStr);
        GridData gd = new GridData();
        this.beforeField = new Text(fields, 2048);
        gd.widthHint = this.convertWidthInCharsToPixels(5);
        this.beforeField.setLayoutData((Object)gd);
        this.beforeField.setText(String.valueOf(prop.collectNstrCodeContextLinesBefore()));
        Label afterLabel = new Label(fields, 0);
        afterLabel.setText(Messages.BslPropertyPage_Lines_of_code_after_NStr);
        this.afterField = new Text(fields, 2048);
        GridData gd2 = new GridData();
        gd2.widthHint = this.convertWidthInCharsToPixels(5);
        this.afterField.setLayoutData((Object)gd2);
        this.afterField.setText(String.valueOf(prop.collectNstrCodeContextLinesAfter()));
        final Button button = (Button)buttonPair.getKey();
        this.beforeField.setEnabled(button.getSelection());
        this.afterField.setEnabled(button.getSelection());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BslPropertyPage.this.beforeField.setEnabled(button.getSelection());
                BslPropertyPage.this.afterField.setEnabled(button.getSelection());
            }
        });
        Label buttonLabel = (Label)buttonPair.getValue();
        Arrays.asList(buttonLabel.getListeners(4)).forEach(listener -> buttonLabel.removeListener(4, listener));
        buttonLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                button.setSelection(!button.getSelection());
                BslPropertyPage.this.beforeField.setEnabled(button.getSelection());
                BslPropertyPage.this.afterField.setEnabled(button.getSelection());
            }
        });
    }

    private void setSelection(Button radio, VariableDuplicatesResolveLevel source, VariableDuplicatesResolveLevel value) {
        radio.setSelection(source == null ? value.equals((Object)VariableDuplicatesResolveLevel.CHECK_KEYWORDS) : value.equals((Object)source));
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Pair<Button, Label> createButton(Composite parent, String label, String key, boolean isCheck) {
        final Button but = new Button(parent, 32);
        but.setData((Object)key);
        but.setSelection(isCheck);
        but.pack();
        this.buttons.put(key, but);
        Label buttonLabel = new Label(parent, 0);
        buttonLabel.setText(label);
        buttonLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                but.setSelection(!but.getSelection());
            }
        });
        buttonLabel.pack();
        return new Pair((Object)but, (Object)buttonLabel);
    }

    protected void performDefaults() {
        super.performDefaults();
        TranslatorProperties prop = this.bslPreferences.getTranslatorProperties(this.getCurrentProject());
        this.buttons.get("maskImplicitVariables").setSelection(prop.maskImplicitVariables());
        this.buttons.get("clearCodeComments").setSelection(prop.clearCodeComments());
        this.buttons.get("clearMethodDescriptions").setSelection(prop.clearMethodDescriptions());
        this.buttons.get("stringLiteralLinesFullTranslationStoredPriority").setSelection(prop.isStringLiteralLinesFullTranslationStoredPriority());
        this.buttons.get("computeQueryResult").setSelection(prop.isComputeQueryResult());
        this.buttons.get("enableTagsInDocComment").setSelection(prop.isEnableTagPartInDocComment());
        this.buttons.get("enableExtendedNStrFeatureKeys").setSelection(prop.isEnableExtendedNStrFeatureKeys());
        this.buttons.get("alphabeticalLanguageOrderInNStr").setSelection(prop.isAlphabeticalLanguageOrderInNStr());
        this.buttons.get("replaceUnknownTypesInDocumentationComment").setSelection(prop.isReplaceUnknownTypesInDocumentationComment());
        VariableDuplicatesResolveLevel[] variableDuplicatesResolveLevelArray = VariableDuplicatesResolveLevel.values();
        int n = variableDuplicatesResolveLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDuplicatesResolveLevel value = variableDuplicatesResolveLevelArray[n2];
            this.buttons.get(value.getLevelName()).setSelection(value.equals((Object)DEFAULT_VARIABLE_DUPLICATE_RESOLVE_LEVEL));
            ++n2;
        }
        CollectorProperties prop2 = this.bslPreferences.getCollectorProperties(this.getCurrentProject());
        this.buttons.get("collectNstrCodeContext").setSelection(prop2.collectNstrCodeContext());
        this.beforeField.setText(String.valueOf(prop2.collectNstrCodeContextLinesBefore()));
        this.afterField.setText(String.valueOf(prop2.collectNstrCodeContextLinesAfter()));
    }

    public boolean performOk() {
        int answer = 0;
        boolean startRebuild = false;
        if (this.isBuildSettingsChanged()) {
            answer = this.askToRebuildProject();
            boolean bl = startRebuild = answer == 0;
        }
        if (answer == 1) {
            return false;
        }
        TranslatorProperties prop = this.bslPreferences.getTranslatorProperties(this.getCurrentProject());
        prop.setMaskImplicitVariables(this.buttons.get("maskImplicitVariables").getSelection());
        prop.setClearCodeComments(this.buttons.get("clearCodeComments").getSelection());
        prop.setEnableTagPartInDocComment(this.buttons.get("enableTagsInDocComment").getSelection());
        prop.setClearMethodDescriptions(this.buttons.get("clearMethodDescriptions").getSelection());
        prop.setEnableExtendedNStrFeatureKeys(this.buttons.get("enableExtendedNStrFeatureKeys").getSelection());
        prop.setAlphabeticalLanguageOrderInNStr(this.buttons.get("alphabeticalLanguageOrderInNStr").getSelection());
        prop.setReplaceUnknownTypesInDocumentationComment(this.buttons.get("replaceUnknownTypesInDocumentationComment").getSelection());
        prop.setStringLiteralLinesFullTranslationStoredPriority(this.buttons.get("stringLiteralLinesFullTranslationStoredPriority").getSelection());
        prop.setComputeQueryResult(this.buttons.get("computeQueryResult").getSelection());
        prop.setCheckVariableDuplicatesResolveLevel(this.getValidationLevelVariable());
        CollectorProperties prop2 = this.bslPreferences.getCollectorProperties(this.getCurrentProject());
        prop2.setCollectNstrCodeContext(this.buttons.get("collectNstrCodeContext").getSelection());
        prop2.setCollectNstrCodeContextLinesBefore(Integer.valueOf(this.beforeField.getText()).intValue());
        prop2.setCollectNstrCodeContextLinesAfter(Integer.valueOf(this.afterField.getText()).intValue());
        if (startRebuild) {
            this.build();
        }
        return true;
    }

    private boolean isBuildSettingsChanged() {
        boolean computeQueryResult = this.buttons.get("computeQueryResult").getSelection();
        boolean enableTags = this.buttons.get("enableTagsInDocComment").getSelection();
        boolean enableExtendedNstrFeatureKeys = this.buttons.get("enableExtendedNStrFeatureKeys").getSelection();
        boolean alphabeticalLanguageOrderInNStr = this.buttons.get("alphabeticalLanguageOrderInNStr").getSelection();
        TranslatorProperties prop = this.bslPreferences.getTranslatorProperties(this.getCurrentProject());
        return computeQueryResult != prop.isComputeQueryResult() || this.bslPreferences.getCollectorProperties(this.getCurrentProject()).collectNstrCodeContext() != this.buttons.get("collectNstrCodeContext").getSelection() || enableTags != prop.isEnableTagPartInDocComment() || enableExtendedNstrFeatureKeys != prop.isEnableExtendedNStrFeatureKeys() || alphabeticalLanguageOrderInNStr != prop.isAlphabeticalLanguageOrderInNStr();
    }

    private int askToRebuildProject() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.BslPropertyPage_Build_settings_changed, null, Messages.BslPropertyPage_Build_settings_have_been_changed_question, 3, new String[]{Messages.BslPropertyPage_Yes_rebuild, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open();
    }

    private VariableDuplicatesResolveLevel getValidationLevelVariable() {
        VariableDuplicatesResolveLevel[] variableDuplicatesResolveLevelArray = VariableDuplicatesResolveLevel.values();
        int n = variableDuplicatesResolveLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDuplicatesResolveLevel value = variableDuplicatesResolveLevelArray[n2];
            if (this.buttons.get(value.getLevelName()).getSelection()) {
                return value;
            }
            ++n2;
        }
        return VariableDuplicatesResolveLevel.CHECK_KEYWORDS;
    }

    private IProject getCurrentProject() {
        return ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
    }

    private void build() {
        IProject project = this.getCurrentProject();
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> project.build(15, monitor), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            BslPlugin.logError(e);
        }
    }
}

