/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix;

import com._1c.g5.v8.dt.bsl.model.FeatureAccess;
import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.ui.quickfix.AbstractExternalQuickfixProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.bsl.settings.BslFeatureSettings;
import com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix.Messages;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.google.common.base.Function;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class InputTranslationQuickfixProvider
extends AbstractExternalQuickfixProvider {
    @Inject
    private ValidatorRegistry validatorRegistry;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    protected ITranslatingProjectManager projectManager;
    @Inject
    protected ITranslationFeatureKeyProvider featureKeyProvider;

    @Fixes(value={@Fix(value="method-translation"), @Fix(value="variable-translation"), @Fix(value="string-literal-translation"), @Fix(value="region-translation"), @Fix(value="nstr-translation")})
    public void inputTranslationFoNamedElement(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] lanuages = issue.getData();
        int i = 0;
        while (i < lanuages.length) {
            String lanugaageName = lanuages[i];
            String label = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_in__L, lanugaageName);
            String description = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_for_named_element_name_in__L, lanugaageName);
            acceptor.accept(issue, label, description, null, this.createNewExternalQuickfixModificationNamed(issue, lanugaageName));
            ++i;
        }
    }

    @Fix(value="dynamic-feature-access-translation")
    public void inputTranslationForDynamicFeatureAccess(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] lanuages = issue.getData();
        int i = 0;
        while (i < lanuages.length) {
            String lanugaageName = lanuages[i];
            String label = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_in__L, lanugaageName);
            String description = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_for_named_element_name_in__L, lanugaageName);
            acceptor.accept(issue, label, description, null, this.createNewFeatureAccessQuickfixModificationNamed(issue, lanugaageName, null, true));
            ++i;
        }
    }

    @Fix(value="dynamic-feature-access-translation-ambiguity")
    public void inputContextTranslationForDynamicFeatureAccess(Issue issue, IssueResolutionAcceptor acceptor) {
        IProject project = this.resourceLookup.getProject(issue.getUriToProblem());
        if (project == null) {
            return;
        }
        ITranslatingProject translatingProject = this.projectManager.getProject(project);
        String language = translatingProject.getModelLanguages().stream().map(TranslateLanguage::getName).findFirst().orElse(null);
        if (language == null) {
            return;
        }
        String[] translations = issue.getData();
        int i = 0;
        while (i < translations.length) {
            String translation = translations[i];
            String label = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Set_context_translation__T__into__L, translation, language);
            String description = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Set_context_translation__T__for_platform_named_element_for__L__model_languages, translation, language);
            acceptor.accept(issue, label, description, null, this.createNewFeatureAccessQuickfixModificationNamed(issue, language, translation, true));
            ++i;
        }
    }

    @Fixes(value={@Fix(value="table-column-translation-duplicate"), @Fix(value="string-literal-keys-translation-duplicate"), @Fix(value="structure-key-translation-duplicate")})
    public void inputTranslationForStringLiteral(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] data = issue.getData();
        int i = 0;
        while (i < data.length) {
            String[] keyLang = data[i].split("\\:");
            if (keyLang.length == 2) {
                String key = keyLang[0];
                String languageName = keyLang[1];
                String label = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation__K__in__L, key, languageName);
                String description = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_for_string_literal_key__K__in__L, key, languageName);
                acceptor.accept(issue, label, description, null, this.createNewExternalQuickfixModificationNamed(languageName, issue, key));
            }
            ++i;
        }
    }

    private InputTranslationQuickfixModification<StringLiteral> createNewExternalQuickfixModificationNamed(String languageName, Issue issue, String key) {
        return new InputTranslationQuickfixModification<StringLiteral>(this, issue, StringLiteral.class, BslFeatureSettings.Literals.STRING_LITERAL__KEY, languageName, key, true){};
    }

    private InputTranslationQuickfixModification<NamedElement> createNewExternalQuickfixModificationNamed(Issue issue, String lanugaageName) {
        return new InputTranslationQuickfixModification<NamedElement>(this, issue, NamedElement.class, (FeatureSettings)McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, lanugaageName, null, false){};
    }

    private InputTranslationQuickfixModification<FeatureAccess> createNewFeatureAccessQuickfixModificationNamed(Issue issue, String lanugaageName, String featureValue, boolean needContextStorage) {
        return new InputTranslationQuickfixModification<FeatureAccess>(this, issue, FeatureAccess.class, (FeatureSettings)BslFeatureSettings.Literals.FEATURE_ACCESS__NAME, lanugaageName, featureValue, needContextStorage){};
    }

    private IInputValidator createNewInputValidator(FeatureValueValidator featureValidator, FeatureValueValidator.ValidationContext context) {
        return newText -> {
            IStatus status = featureValidator.isValid(newText, context);
            if (status.isOK()) {
                return null;
            }
            if (status.isMultiStatus()) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < status.getChildren().length) {
                    IStatus child = status.getChildren()[i];
                    if (!child.isOK()) {
                        if (sb.length() > 0) {
                            sb.append(System.lineSeparator());
                        }
                        sb.append(child.getMessage());
                    }
                    ++i;
                }
                return sb.toString();
            }
            return status.getMessage();
        };
    }

    private TextEdit getChanges(final EObject object, String lanugaageName, final FeatureSettings settings, String featureValue, boolean needContextStorage) {
        StorageID id;
        String featureString;
        final IProject project = this.resourceLookup.getProject(object);
        if (project == null) {
            return null;
        }
        @NonNull ITranslatingProject translatingProject = this.projectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return null;
        }
        Optional<TranslateLanguage> optional = translatingProject.getModelLanguages().stream().filter(l -> l.getName().equals(lanugaageName)).findFirst();
        if (optional.isEmpty()) {
            return null;
        }
        final TranslateLanguage language = optional.get();
        String string = featureString = settings instanceof EFeatureSettings ? (String)object.eGet(((EFeatureSettings)settings).getEFeature()) : featureValue;
        if (StringUtils.isNullOrEmpty((String)featureValue)) {
            featureValue = featureString;
        }
        FeatureValueValidator featureValidator = this.validatorRegistry.getValidator(settings);
        if (needContextStorage) {
            StorageID defaultId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, defaultId);
            if (storage.getType().equals((Object)ITranslationStorageProvider.Storage.Type.CONTEXT)) {
                id = defaultId;
            } else {
                StorageID found = null;
                List ids = this.storageSettingsManager.getReadStorageIds(project);
                for (StorageID editable : ids) {
                    storage = this.storageManager.getStorage(project, editable);
                    if (storage == null || !storage.getType().equals((Object)ITranslationStorageProvider.Storage.Type.CONTEXT) || storage.isReadOnly()) continue;
                    found = editable;
                    break;
                }
                if (found == null) {
                    return null;
                }
                id = found;
            }
        } else {
            id = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
        }
        FeatureValueValidator.ValidationContext context = new FeatureValueValidator.ValidationContext(){

            public IProject getProject() {
                return project;
            }

            public TranslationKey getTranslationKey() {
                if (settings instanceof EFeatureSettings) {
                    FeatureKey featureKey = InputTranslationQuickfixProvider.this.featureKeyProvider.getFeatureKey(object, settings);
                    return new ContextTranslationKeyImpl(InputTranslationQuickfixProvider.this.resourceLookup.getPlatformResource(object), featureKey, settings, featureString);
                }
                IFile file = InputTranslationQuickfixProvider.this.resourceLookup.getPlatformResource(object);
                FeatureKey featureKey = InputTranslationQuickfixProvider.this.featureKeyProvider.getKey(object);
                return new PersistableFeatureValue(file.getFullPath().toString(), featureKey.skipLast(1).append(featureString).append("Key"), settings, featureString, true);
            }

            public TranslateLanguage getLanguage() {
                return language;
            }

            public ITranslationStorageProvider.Storage getStorage() {
                return InputTranslationQuickfixProvider.this.storageManager.getStorage(project, id);
            }
        };
        IInputValidator validator = this.createNewInputValidator(featureValidator, context);
        String title = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Input_translation_in__L, lanugaageName);
        String dialogMessage = MessageFormat.format(Messages.InputTranslationQuickfixProvider_Name__N__save_in__S, featureString, this.storageManager.getStorageProvider(id).getStorageDescription(project, id.getSegment()));
        InputDialog input = new InputDialog(Display.getCurrent().getActiveShell(), title, dialogMessage, featureValue, validator);
        if (input.open() == 0) {
            if (context.getStorage() instanceof ITranslationStorageProvider.ContextStorage && context.getTranslationKey() instanceof ContextTranslationKey) {
                ((ITranslationStorageProvider.ContextStorage)context.getStorage()).setTranslation((ContextTranslationKey)context.getTranslationKey(), language, input.getValue(), true);
            } else if (context.getStorage() instanceof ITranslationStorageProvider.DictionaryStorage) {
                ((ITranslationStorageProvider.DictionaryStorage)context.getStorage()).setTranslation(context.getTranslationKey(), language, input.getValue(), true);
            }
            if (settings instanceof EFeatureSettings) {
                List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)((EFeatureSettings)settings).getEFeature());
                if (!nodes.isEmpty()) {
                    return new ReplaceEdit(((INode)nodes.get(0)).getOffset(), featureString.length(), featureString);
                }
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
                if (node != null) {
                    return new ReplaceEdit(node.getOffset(), node.getLength(), node.getText());
                }
            }
        }
        return null;
    }

    private abstract class InputTranslationQuickfixModification<E extends EObject>
    extends AbstractExternalQuickfixProvider.ExternalQuickfixModification<E> {
        public InputTranslationQuickfixModification(Issue issue, Class<E> clazz, final FeatureSettings settings, final String lanugaageName, final String featureValue, final boolean needContextStorage) {
            super(issue, clazz, new Function<E, TextEdit>(){

                public TextEdit apply(E input) {
                    return InputTranslationQuickfixProvider.this.getChanges((EObject)input, lanugaageName, settings, featureValue, needContextStorage);
                }
            });
        }
    }
}

