/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix;

import com._1c.g5.v8.dt.bsl.model.StringLiteral;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.IStringLiteralTypeComputer;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.LiteralType;
import com._1c.g5.v8.dt.bsl.stringliteral.contenttypes.TypeUtil;
import com._1c.g5.v8.dt.bsl.ui.quickfix.AbstractExternalQuickfixProvider;
import com.e1c.langtool.v8.dt.internal.bsl.ui.quickfix.Messages;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.Issue;

public class StringLiteralTypeQuickfixProvider
extends AbstractExternalQuickfixProvider {
    @Inject
    private IStringLiteralTypeComputer typeComputer;

    @Fix(value="string-literal-types")
    public void removeAnnotation(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] typeNames = issue.getData();
        int i = 0;
        while (i < typeNames.length) {
            String typeName = typeNames[i];
            String label = MessageFormat.format(Messages.StringLiteralTypeQuickfixProvider_Remove_annotation__0, typeName);
            acceptor.accept(issue, label, Messages.StringLiteralTypeQuickfixProvider_Conflicting_type_annotation_will_be_removed, null, (IModification)new AbstractExternalQuickfixProvider.ExternalQuickfixModification(issue, StringLiteral.class, literal -> {
                ICompositeNode literalNode = NodeModelUtils.getNode((EObject)literal);
                Map nodes = this.typeComputer.getAnnotationNodes(literal);
                for (Map.Entry entry : nodes.entrySet()) {
                    if (!((LiteralType)entry.getKey()).getName().equalsIgnoreCase(typeName) && !((LiteralType)entry.getKey()).getNameRu().equalsIgnoreCase(typeName)) continue;
                    int indexOnLastLine = this.typeComputer.indexOnLastLine(literal);
                    Pair position = TypeUtil.getAnnotationOffsetAndLength((LiteralType)((LiteralType)entry.getKey()), (ICompositeNode)literalNode, (int)indexOnLastLine, (INode)((INode)entry.getValue()));
                    return new DeleteEdit(((Integer)position.getFirst()).intValue(), ((Integer)position.getSecond()).intValue());
                }
                return null;
            }));
            ++i;
        }
    }
}

