/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor;

import com._1c.g5.gumtree.core.tree.INode;
import com._1c.g5.gumtree.core.tree.Mapping;
import com._1c.g5.gumtree.core.tree.MappingStore;
import com._1c.g5.gumtree.core.tree.Node;
import com._1c.g5.gumtree.core.tree.TreeGeneratorException;
import com._1c.g5.gumtree.core.utils.CompareUtils;
import com._1c.g5.v8.dt.bsl.gumtree.tree.generator.BslTreeGenerator;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class BslDocumentMapper {
    private static final String METHODNAME_GENERATE_GUMTREE_AST = "generateGumTreeAST";
    private static final Set<String> NODE_TYPE_WHITELIST = new HashSet<String>(Arrays.asList("Function", "Procedure", "RegionPreprocessor", "RegionPreprocessorDeclareStatement", "ReturnStatement", "TryExceptStatement", "TryExceptStatementExcept"));
    private final IParser BSL_PARSER;
    private int leftDocumentLineCount;
    private int rightDocumentLineCount;
    private final NavigableMap<Integer, Integer> lineMapping = new TreeMap<Integer, Integer>();
    private final NavigableMap<Integer, Integer> inverseLineMapping = new TreeMap<Integer, Integer>();

    public BslDocumentMapper() {
        IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)"*.bsl"));
        this.BSL_PARSER = resourceServiceProvider != null ? (IParser)resourceServiceProvider.get(IParser.class) : null;
    }

    public void updateMapping(IDocument leftDocument, IDocument rightDocument, IProgressMonitor monitor) {
        MappingStore mappingStore;
        try {
            INode leftTree = this.generateGumTreeAST(leftDocument);
            INode rightTree = this.generateGumTreeAST(rightDocument);
            mappingStore = leftTree != null && rightTree != null ? CompareUtils.compareTwoTrees((INode)this.filterTree(leftTree), (INode)this.filterTree(rightTree), (int)0, (IProgressMonitor)monitor) : null;
        }
        catch (TreeGeneratorException e) {
            if (BslPlugin.getDefault().isDebugging()) {
                BslPlugin.logError(e);
            }
            mappingStore = null;
        }
        this.updateLineMapping(mappingStore, leftDocument, rightDocument);
    }

    private INode generateGumTreeAST(IDocument document) throws TreeGeneratorException {
        if (this.BSL_PARSER != null) {
            BslTreeGenerator treeGenerator = new BslTreeGenerator(document);
            StringReader reader = new StringReader(document.get());
            IParseResult parseResult = this.BSL_PARSER.parse((Reader)reader);
            EObject root = parseResult.getRootASTElement();
            try {
                Method generateGumTreeASTMethod = treeGenerator.getClass().getDeclaredMethod(METHODNAME_GENERATE_GUMTREE_AST, EObject.class);
                generateGumTreeASTMethod.setAccessible(true);
                INode result = (INode)generateGumTreeASTMethod.invoke((Object)treeGenerator, root);
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BslPlugin.logError(e);
                return null;
            }
        }
        return null;
    }

    private void updateLineMapping(MappingStore mappingStore, IDocument leftDocument, IDocument rightDocument) {
        this.lineMapping.clear();
        this.inverseLineMapping.clear();
        try {
            this.leftDocumentLineCount = leftDocument.getNumberOfLines();
            this.rightDocumentLineCount = rightDocument.getNumberOfLines();
            this.lineMapping.put(0, 0);
            this.inverseLineMapping.put(0, 0);
            if (mappingStore != null) {
                for (Mapping item : mappingStore) {
                    int leftLine = leftDocument.getLineOfOffset(((INode)item.getFirst()).getPos());
                    int rightLine = rightDocument.getLineOfOffset(((INode)item.getSecond()).getPos());
                    this.lineMapping.put(leftLine, rightLine);
                    this.inverseLineMapping.put(rightLine, leftLine);
                }
            }
            this.lineMapping.put(this.leftDocumentLineCount, this.rightDocumentLineCount);
            this.inverseLineMapping.put(this.rightDocumentLineCount, this.leftDocumentLineCount);
        }
        catch (BadLocationException e) {
            BslPlugin.logError(e);
        }
    }

    public int getMatchingTopLine(boolean isLeftSide, int topLineNumber, int visibleLineCount) {
        int passiveEditorBaseLine;
        int activeEditorBaseLine;
        int passiveDocumentLineCount;
        int activeDocumentLineCount;
        NavigableMap<Integer, Integer> mapping;
        int middleLine = topLineNumber + visibleLineCount / 2;
        if (isLeftSide) {
            mapping = this.lineMapping;
            activeDocumentLineCount = this.leftDocumentLineCount;
            passiveDocumentLineCount = this.rightDocumentLineCount;
        } else {
            mapping = this.inverseLineMapping;
            activeDocumentLineCount = this.rightDocumentLineCount;
            passiveDocumentLineCount = this.leftDocumentLineCount;
        }
        Map.Entry<Integer, Integer> entry = mapping.ceilingEntry(middleLine);
        if (entry == null) {
            entry = mapping.lastEntry();
        }
        if (entry == null) {
            activeEditorBaseLine = activeDocumentLineCount - 1;
            passiveEditorBaseLine = passiveDocumentLineCount - 1;
        } else {
            activeEditorBaseLine = entry.getKey();
            passiveEditorBaseLine = entry.getValue();
        }
        int lineDelta = activeEditorBaseLine >= middleLine ? 0 : middleLine - activeEditorBaseLine;
        return Math.max(0, passiveEditorBaseLine + lineDelta - (activeEditorBaseLine - topLineNumber));
    }

    private INode filterTree(INode tree) {
        Node result = new Node((Node)tree);
        for (INode child : tree.getChildren()) {
            if (!NODE_TYPE_WHITELIST.contains(child.getTokenName())) continue;
            result.addChild(this.filterTree(child));
        }
        return result;
    }
}

