/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.dt.core.lifecycle.ProjectContext;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.lifecycle.ILifecycleContext;
import com._1c.g5.v8.dt.lifecycle.IServiceContextLifecycleListener;
import com._1c.g5.v8.dt.lifecycle.IServicesOrchestrator;
import com._1c.g5.v8.dt.lifecycle.ServiceState;
import com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.ISideBySideEditorProxyInput;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditor;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorInput;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ProxyInputHelperService {
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IServicesOrchestrator serviceOrchestrator;

    public void scheduleEditorReopen(ISideBySideEditorProxyInput editorInput, SideBySideEditor editor) {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.serviceOrchestrator.addListener((IServiceContextLifecycleListener)new EditorReopenTask(workbenchPage, editor, editorInput));
    }

    private class EditorReopenTask
    implements IServiceContextLifecycleListener {
        private IWorkbenchPage workbenchPage;
        private SideBySideEditor editor;
        private EObject leftObject;
        private EObject rightObject;
        private EObject resolvedLeftObject;
        private EObject resolvedRightObject;

        public EditorReopenTask(IWorkbenchPage workbenchPage, SideBySideEditor editor, ISideBySideEditorProxyInput editorInput) {
            this.workbenchPage = workbenchPage;
            this.editor = editor;
            this.leftObject = editorInput.getLeftObject();
            this.rightObject = editorInput.getRightObject();
            this.resolvedLeftObject = this.leftObject.eIsProxy() ? null : this.leftObject;
            this.resolvedRightObject = this.rightObject.eIsProxy() ? null : this.rightObject;
        }

        public void contextStateChanged(ILifecycleContext context, ServiceState state) {
            if (context instanceof ProjectContext && state == ServiceState.STARTED) {
                IBmEngine engine = ProxyInputHelperService.this.modelManager.getModel(((ProjectContext)context).getProject()).getEngine();
                if (this.resolvedLeftObject == null) {
                    this.resolvedLeftObject = engine.resolve(EcoreUtil.getURI((EObject)this.leftObject), null);
                }
                if (this.resolvedRightObject == null) {
                    this.resolvedRightObject = engine.resolve(EcoreUtil.getURI((EObject)this.rightObject), null);
                }
                if (this.resolvedLeftObject != null && this.resolvedRightObject != null) {
                    ProxyInputHelperService.this.serviceOrchestrator.removeListener((IServiceContextLifecycleListener)this);
                    Display display = Display.getDefault();
                    display.asyncExec(() -> {
                        try {
                            this.editor.close();
                            SideBySideEditorInput editorInput = new SideBySideEditorInput(this.resolvedLeftObject, this.resolvedRightObject);
                            display.asyncExec(() -> {
                                try {
                                    this.workbenchPage.openEditor(editorInput, "com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.SideBySideBslEditor");
                                }
                                catch (Exception e) {
                                    BslPlugin.logError(e);
                                }
                            });
                        }
                        catch (Exception e) {
                            BslPlugin.logError(e);
                        }
                    });
                }
            }
        }
    }
}

