/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor;

import com._1c.g5.v8.dt.common.ui.part.EObjectEditorInput;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupport;
import com._1c.g5.v8.dt.core.filesystem.IProjectFileSystemSupportProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.navigator.adapters.CollectionNavigatorAdapterBase;
import com._1c.g5.v8.dt.ui.util.LabelUtil;
import com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.ISideBySideEditorInput;
import com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.ISideBySideEditorInputExtension;
import com.e1c.langtool.v8.dt.bsl.ui.sidebysideeditor.ISideBySideEditorProxyInput;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.BslDocumentMapper;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.Messages;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.ProxyInputHelperService;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorSelectionProvider;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorSite;
import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class SideBySideEditor
extends EditorPart
implements IPageChangeProvider {
    private static final String BSL_EDITOR_CONTRIBUTOR_NAME = "com._1c.g5.v8.dt.bsl.ui";
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IProjectFileSystemSupportProvider projectFileSystemSupportProvider;
    @Inject
    private ProxyInputHelperService proxyInputHelper;
    private Display display;
    private FormToolkit toolkit;
    private Form form;
    private Composite formBody;
    private IEditorPart leftEditorPart;
    private IEditorPart rightEditorPart;
    private IEditorPart activeEditorPart;
    private int synchronousScrollLock = 0;
    private BslDocumentMapper documentMapper = new BslDocumentMapper();
    private DocumentMappingUpdateJob documentMappingUpdateJob = new DocumentMappingUpdateJob();
    private IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            SideBySideEditor.this.documentMappingUpdateJob.schedule(500L);
        }
    };
    private INestable activeServiceLocator;
    private IServiceLocator pageContainerSite;
    private ListenerList<IPageChangedListener> pageChangeListeners = new ListenerList(1);

    public IEditorPart getActiveEditor() {
        return this.activeEditorPart;
    }

    public IEditorPart getLeftEditor() {
        return this.leftEditorPart;
    }

    public IEditorPart getRightEditor() {
        return this.rightEditorPart;
    }

    public void createPartControl(Composite parent) {
        ISideBySideEditorInput editorInput = (ISideBySideEditorInput)this.getEditorInput();
        this.toolkit = new FormToolkit(this.display);
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        this.formBody = this.form.getBody();
        this.formBody.setLayout((Layout)new FillLayout());
        this.setPartName(editorInput.getName());
        if (!(editorInput instanceof ISideBySideEditorProxyInput)) {
            this.form.setText(SideBySideEditor.getTitle(editorInput));
            SashForm splitView = new SashForm(this.formBody, 256);
            try {
                IEditorSite serviceLocator;
                IEditorInput leftEditorInput = null;
                IEditorInput rightEditorInput = null;
                if (editorInput instanceof ISideBySideEditorInputExtension) {
                    leftEditorInput = ((ISideBySideEditorInputExtension)editorInput).getLeftEditorInput();
                    rightEditorInput = ((ISideBySideEditorInputExtension)editorInput).getRightEditorInput();
                } else {
                    leftEditorInput = this.getBslEditorInput(editorInput.getLeftObject());
                    rightEditorInput = this.getBslEditorInput(editorInput.getRightObject());
                }
                this.leftEditorPart = this.createEditorControl((Composite)splitView, leftEditorInput);
                this.rightEditorPart = this.createEditorControl((Composite)splitView, rightEditorInput);
                String title = MessageFormat.format("{0}  \u2192 {1}", this.leftEditorPart.getTitle(), this.rightEditorPart.getTitle());
                this.form.setText(title);
                this.installDocumentChangeListener(this.leftEditorPart);
                this.installDocumentChangeListener(this.rightEditorPart);
                this.updateDocumentMapping((IProgressMonitor)new NullProgressMonitor());
                this.installSynchronousScrolling(this.leftEditorPart, this.rightEditorPart);
                this.setActiveEditor(this.leftEditorPart);
                IEditorPart part = this.getActiveEditor();
                if (part != null && (serviceLocator = part.getEditorSite()) instanceof INestable) {
                    this.activeServiceLocator = (INestable)serviceLocator;
                    this.activeServiceLocator.activate();
                }
            }
            catch (CoreException e) {
                BslPlugin.logError(e);
            }
        }
    }

    private IEditorPart createEditorControl(Composite parent, IEditorInput editorInput) throws PartInitException {
        IEditorPart editorPart = SideBySideEditor.createBslEditorPart();
        if (editorPart != null) {
            editorPart.init(this.createSite(editorPart), editorInput);
            Composite editorPane = new Composite(parent, 0);
            editorPane.setLayout((Layout)new FillLayout());
            editorPart.createPartControl(editorPane);
            editorPart.addPropertyListener((source, propertyId) -> this.handlePropertyChange(propertyId));
            this.installFocusListener(editorPart);
        }
        return editorPart;
    }

    private static String getTitle(ISideBySideEditorInput editorInput) {
        if (editorInput instanceof ISideBySideEditorInputExtension) {
            return ((ISideBySideEditorInputExtension)editorInput).getLeftEditorInput().getToolTipText();
        }
        EObject model = editorInput.getLeftObject();
        if (model == null) {
            return "";
        }
        return LabelUtil.getPath((Object)model, (String)Messages.SideBySideEditor_Page_Title_Path_Separator, CollectionNavigatorAdapterBase.class);
    }

    private IEditorInput getBslEditorInput(EObject object) {
        IProjectFileSystemSupport projectFileSystemSupport;
        IFile file;
        IProject project = this.resourceLookup.getProject(object);
        if (project != null && (file = (projectFileSystemSupport = this.projectFileSystemSupportProvider.getProjectFileSystemSupport(project)).getFile(object)) != null) {
            return new FileEditorInput(file);
        }
        return new EObjectEditorInput(object, null);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.display = Display.getCurrent();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new SideBySideEditorSelectionProvider(this));
        if (input instanceof ISideBySideEditorProxyInput) {
            this.proxyInputHelper.scheduleEditorReopen((ISideBySideEditorProxyInput)input, this);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.leftEditorPart != null) {
            this.leftEditorPart.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.leftEditorPart != null) {
            this.leftEditorPart.doSaveAs();
        }
    }

    public boolean isDirty() {
        return this.leftEditorPart != null && this.leftEditorPart.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.setFocus();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        IEditorPart innerEditor;
        Object result = super.getAdapter(adapter);
        if (result == null && this.display != null && (innerEditor = this.activeEditorPart) != null && innerEditor != this) {
            result = Adapters.adapt((Object)innerEditor, adapter);
        }
        return (T)result;
    }

    private static IEditorPart createBslEditorPart() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.ui.editors");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (configurationElement.getName().equals("editor") && configurationElement.getContributor().getName().equals(BSL_EDITOR_CONTRIBUTOR_NAME)) {
                try {
                    return (IEditorPart)configurationElement.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangeListeners.remove((Object)listener);
    }

    public Object getSelectedPage() {
        return this.activeEditorPart;
    }

    void close() {
        PartSite partSite = (PartSite)this.getSite();
        MPart model = partSite.getModel();
        Widget widget = (Widget)model.getWidget();
        if (widget != null && !widget.isDisposed()) {
            this.getSite().getPage().closeEditor((IEditorPart)this, true);
        }
    }

    public void dispose() {
        if (this.leftEditorPart != null) {
            this.uninstallDocumentChangeListener(this.leftEditorPart);
        }
        if (this.rightEditorPart != null) {
            this.uninstallDocumentChangeListener(this.rightEditorPart);
        }
        this.documentMappingUpdateJob.cancel();
        this.deactivateSite(true, false);
        this.pageChangeListeners.clear();
        if (this.leftEditorPart != null) {
            this.disposePart((IWorkbenchPart)this.leftEditorPart);
        }
        if (this.rightEditorPart != null) {
            this.disposePart((IWorkbenchPart)this.rightEditorPart);
        }
        if (this.pageContainerSite instanceof IDisposable) {
            ((IDisposable)this.pageContainerSite).dispose();
            this.pageContainerSite = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite partSite = part.getSite();
                part.dispose();
                if (partSite instanceof SideBySideEditorSite) {
                    ((SideBySideEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    private IServiceLocator getPageContainerSite() {
        if (this.pageContainerSite == null) {
            IServiceLocatorCreator slc = (IServiceLocatorCreator)this.getSite().getService(IServiceLocatorCreator.class);
            this.pageContainerSite = slc.createServiceLocator((IServiceLocator)this.getSite(), null, () -> this.close());
        }
        return this.pageContainerSite;
    }

    private IEditorSite createSite(IEditorPart editorPart) {
        return new SideBySideEditorSite(this, editorPart);
    }

    private void setActiveEditor(IEditorPart editorPart) {
        if (this.activeEditorPart != editorPart) {
            ISelectionProvider selectionProvider;
            IEditorPart activeEditor;
            this.deactivateSite(false, false);
            IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
            if (partService.getActivePart() == this) {
                this.setFocus();
            }
            if ((activeEditor = editorPart) != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                ISelectionProvider outerProvider = this.getSite().getSelectionProvider();
                if (outerProvider instanceof SideBySideEditorSelectionProvider) {
                    SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
                    SideBySideEditorSelectionProvider provider = (SideBySideEditorSelectionProvider)outerProvider;
                    provider.fireSelectionChanged(event);
                    provider.firePostSelectionChanged(event);
                } else if (BslPlugin.getDefault().isDebugging()) {
                    BslPlugin.logError("SideBySideEditor " + this.getTitle() + " did not propogate selection for " + activeEditor.getTitle());
                }
            }
            this.activeEditorPart = editorPart;
            this.activateSite();
            Object selectedPage = this.getSelectedPage();
            if (selectedPage != null) {
                this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, selectedPage));
            }
        }
    }

    protected final void deactivateSite(boolean immediate, boolean containerSiteActive) {
        IServiceLocator containerSite;
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        IKeyBindingService service = this.getSite().getKeyBindingService();
        if (this.activeEditorPart == null || immediate) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService(null);
            } else {
                BslPlugin.logError("SideBySideEditor.deactivateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead.");
            }
        }
        if (containerSiteActive && (containerSite = this.getPageContainerSite()) instanceof INestable) {
            this.activeServiceLocator = (INestable)containerSite;
            this.activeServiceLocator.activate();
        }
    }

    protected final void activateSite() {
        if (this.activeServiceLocator != null) {
            this.activeServiceLocator.deactivate();
            this.activeServiceLocator = null;
        }
        IKeyBindingService service = this.getSite().getKeyBindingService();
        IEditorPart editor = this.activeEditorPart;
        if (editor != null) {
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
            } else {
                BslPlugin.logError("SideBySideEditor.activateSite()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + service.getClass().getName() + " instead.");
            }
            IEditorSite serviceLocator = editor.getEditorSite();
            if (serviceLocator instanceof INestable) {
                this.activeServiceLocator = (INestable)serviceLocator;
                this.activeServiceLocator.activate();
            }
        }
    }

    private void firePageChanged(final PageChangedEvent event) {
        for (final IPageChangedListener listener : this.pageChangeListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.pageChanged(event);
                }
            });
        }
    }

    private void installFocusListener(final IEditorPart editorPart) {
        StyledText styledText;
        ISourceViewer sourceViewer = this.getSourceViewer(editorPart);
        if (sourceViewer != null && (styledText = sourceViewer.getTextWidget()) != null) {
            styledText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent event) {
                    SideBySideEditor.this.setActiveEditor(editorPart);
                }

                public void focusLost(FocusEvent event) {
                }
            });
        }
    }

    private void handlePropertyChange(int propertyId) {
        this.firePropertyChange(propertyId);
    }

    private ISourceViewer getSourceViewer(IEditorPart editorPart) {
        return (ISourceViewer)editorPart.getAdapter(ITextOperationTarget.class);
    }

    private void installSynchronousScrolling(IEditorPart leftEditorPart, IEditorPart rightEditorPart) {
        ISourceViewer leftSourceViewer = this.getSourceViewer(leftEditorPart);
        ISourceViewer rightSourceViewer = this.getSourceViewer(rightEditorPart);
        if (leftSourceViewer != null && rightSourceViewer != null) {
            this.installSynchronousScrollingListener(leftSourceViewer, rightSourceViewer, true);
            this.installSynchronousScrollingListener(rightSourceViewer, leftSourceViewer, false);
        }
    }

    private void installSynchronousScrollingListener(ISourceViewer activeSourceViewer, ISourceViewer passiveSourceViewer, boolean isLeftPart) {
        activeSourceViewer.addViewportListener(verticalOffset -> this.handleVerticalScrolling(activeSourceViewer, passiveSourceViewer, isLeftPart));
    }

    private void handleVerticalScrolling(ISourceViewer activeSourceViewer, ISourceViewer passiveSourceViewer, boolean isLeftPart) {
        if (this.synchronousScrollLock == 0) {
            ++this.synchronousScrollLock;
            try {
                int topLineNumber = activeSourceViewer.getTopIndex();
                int visibleLineCount = activeSourceViewer.getBottomIndex() - topLineNumber + 1;
                int passiveTopIndex = this.documentMapper.getMatchingTopLine(isLeftPart, topLineNumber, visibleLineCount);
                passiveSourceViewer.setTopIndex(passiveTopIndex);
            }
            finally {
                --this.synchronousScrollLock;
            }
        }
    }

    private void updateDocumentMapping(IProgressMonitor monitor) {
        if (this.leftEditorPart != null && this.rightEditorPart != null) {
            ISourceViewer rightSourceViewer;
            IDocument leftDocument = null;
            IDocument rightDocument = null;
            ISourceViewer leftSourceViewer = this.getSourceViewer(this.leftEditorPart);
            if (leftSourceViewer != null) {
                leftDocument = leftSourceViewer.getDocument();
            }
            if ((rightSourceViewer = this.getSourceViewer(this.rightEditorPart)) != null) {
                rightDocument = this.getSourceViewer(this.rightEditorPart).getDocument();
            }
            if (leftDocument != null && rightDocument != null) {
                this.documentMapper.updateMapping(leftDocument, rightDocument, monitor);
            }
        }
    }

    private void installDocumentChangeListener(IEditorPart editorPart) {
        IDocument document = this.getSourceViewer(editorPart).getDocument();
        document.addDocumentListener(this.documentListener);
    }

    private void uninstallDocumentChangeListener(IEditorPart editorPart) {
        IDocument document = this.getSourceViewer(editorPart).getDocument();
        if (document != null) {
            document.removeDocumentListener(this.documentListener);
        }
    }

    private class DocumentMappingUpdateJob
    extends Job {
        public DocumentMappingUpdateJob() {
            super(Messages.SideBySideEditor_DocumentMappingUpdateJob_Title);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.SideBySideEditor_DocumentMappingUpdateJob_Title, -1);
            SideBySideEditor.this.updateDocumentMapping(monitor);
            return Status.OK_STATUS;
        }
    }
}

