/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com._1c.g5.wiring.ServiceAccess;
import com.e1c.langtool.v8.dt.internal.bsl.ui.BslPlugin;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorInput;
import com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorProxyInput;
import com.google.inject.Inject;
import java.time.Duration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class SideBySideEditorInputElementFactory
implements IElementFactory {
    public static final String FACTORY_ID = "com.e1c.langtool.v8.dt.internal.bsl.ui.sidebysideeditor.SideBySideEditorInputElementFactory";
    private static final String KEY_LEFT_OBJECT_PROJECT = "leftObjectProject";
    private static final String KEY_LEFT_OBJECT_URI = "leftObjectURI";
    private static final String KEY_RIGHT_OBJECT_PROJECT = "rightObjectProject";
    private static final String KEY_RIGHT_OBJECT_URI = "rightObjectURI";
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IWorkspaceOrchestrator workspaceOrchestrator;
    private final Object waitLock = new Object();

    public static void saveElement(IMemento memento, SideBySideEditorInput editorInput) {
        SideBySideEditorInputElementFactory.saveObject(memento, editorInput.getLeftObject(), KEY_LEFT_OBJECT_PROJECT, KEY_LEFT_OBJECT_URI);
        SideBySideEditorInputElementFactory.saveObject(memento, editorInput.getRightObject(), KEY_RIGHT_OBJECT_PROJECT, KEY_RIGHT_OBJECT_URI);
    }

    private static void saveObject(IMemento memento, EObject object, String projectKey, String uriKey) {
        URI modelUri;
        if (object == null) {
            return;
        }
        IProject project = ((IResourceLookup)ServiceAccess.get(IResourceLookup.class)).getProject(object);
        if (project == null) {
            throw new IllegalStateException("No project found for the model.");
        }
        String projectName = project.getName();
        if (projectName != null && projectName.length() != 0) {
            memento.putString(projectKey, projectName);
            modelUri = SideBySideEditorInputElementFactory.getURI(object);
            if (modelUri == null) {
                throw new IllegalStateException("Model has no URI.");
            }
        } else {
            throw new IllegalStateException("Project has no name.");
        }
        memento.putString(uriKey, modelUri.toString());
    }

    public IAdaptable createElement(IMemento memento) {
        EObject leftObject = this.readEObject(memento, KEY_LEFT_OBJECT_PROJECT, KEY_LEFT_OBJECT_URI);
        EObject rightObject = this.readEObject(memento, KEY_RIGHT_OBJECT_PROJECT, KEY_RIGHT_OBJECT_URI);
        if (leftObject != null && rightObject != null) {
            if (leftObject.eIsProxy() || rightObject.eIsProxy()) {
                return new SideBySideEditorProxyInput(leftObject, rightObject);
            }
            return new SideBySideEditorInput(leftObject, rightObject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EObject readEObject(IMemento memento, String projectKey, String uriKey) {
        String projectName = memento.getString(projectKey);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            throw new IllegalStateException("Unable to resolve the project.");
        }
        long startedWaiting = System.currentTimeMillis();
        long deadline = startedWaiting + Duration.ofMinutes(1L).toMillis();
        while (!this.workspaceOrchestrator.isStarted(project) && System.currentTimeMillis() < deadline) {
            Object object = this.waitLock;
            synchronized (object) {
                try {
                    this.waitLock.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        boolean servicesReady = this.workspaceOrchestrator.isStarted(project);
        IBmModel bmModel = this.modelManager.getModel(project);
        if (!servicesReady || bmModel == null) {
            URI uri = URI.createURI((String)memento.getString(uriKey));
            EObject model = EcoreFactory.eINSTANCE.createEObject();
            ((InternalEObject)model).eSetProxyURI(uri);
            BslPlugin.logError("No BM model found for the project.");
            return model;
        }
        URI uri = URI.createURI((String)memento.getString(uriKey));
        EObject model = bmModel.getEngine().resolve(uri, null);
        if (model == null) {
            BslPlugin.logError("Unable to resolve the model.");
            return null;
        }
        return model;
    }

    private static URI getURI(EObject object) {
        return object instanceof IBmObject ? ((IBmObject)object).bmGetUri() : EcoreUtil.getURI((EObject)object);
    }
}

