/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md;

import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbViewExternalTranslationProvider
implements IExternalTranslationProvider {
    private static final String LANGUAGE_CODE_EN = "en";
    private static final String LANGUAGE_CODE_RU = "ru";
    private static final Set<String> LANGUAGE_CODES = ImmutableSet.of((Object)"en", (Object)"ru");
    private static final Map<String, String> LANGUAGES = Map.of("en", ScriptVariant.ENGLISH.getName(), "ru", ScriptVariant.RUSSIAN.getName());
    @Inject
    private InternalizeDbViewTermsProvider dbViewTermsProvider;

    public String getTranslationItemImageName() {
        return "icons/obj16/db_view.png";
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        if (StringUtils.isNotEmpty((String)text)) {
            String translation = null;
            if (LANGUAGE_CODE_EN.equalsIgnoreCase(sourceLocale) && LANGUAGE_CODE_RU.equalsIgnoreCase(targetLocale)) {
                translation = this.dbViewTermsProvider.getInternalizeEnumValue(text, true);
            } else if (LANGUAGE_CODE_RU.equalsIgnoreCase(sourceLocale) && LANGUAGE_CODE_EN.equalsIgnoreCase(targetLocale)) {
                translation = this.dbViewTermsProvider.getInternalizeEnumValue(text, false);
            }
            if (StringUtils.isNotEmpty(translation)) {
                return Lists.newArrayList((Object[])new String[]{translation});
            }
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        texts.forEach(text -> {
            List<String> list = res.put((String)text, this.translate((String)text, sourceLocale, targetLocale));
        });
        return res;
    }

    public Set<String> getLanguageCodes() {
        return LANGUAGE_CODES;
    }

    public Map<String, String> getLanguages(String targetLocale) {
        return LANGUAGES;
    }
}

