/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.derived.IDerivedDataManager;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.BasicTemplate;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.TemplateType;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.md.MdPlugin;
import com.e1c.langtool.v8.dt.md.MdObjectProcessor;
import com.google.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;

public class MdFeaturesCollector
extends MdObjectProcessor
implements FeatureValueCollector {
    private static final String DD_MOXEL_ASYNC_IMPORT_SEGMENT = "MXL_A_IMP";
    private static final long DD_WAIT = Duration.ofHours(2L).toMillis();
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IQualifiedNameFilePathConverter qualifiedNameFilePathConverter;
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private EObject object;

    public static MdFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        MdFeaturesCollector collector = new MdFeaturesCollector(object, parameters, addAction);
        MdPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public MdFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super((IBmObject)object);
        this.object = object;
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        super.setProcessChildObjects(parameters.isCollectChildObjects());
        this.setWaitDerivedDataComputation(parameters.isCollectModelStrings());
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz, IProgressMonitor monitor) {
        if (object == null) {
            return;
        }
        if (object instanceof IBmObject && ((IBmObject)object).bmIsTop() && ((IBmObject)object).bmGetEngine() != null) {
            monitor.subTask(((IBmObject)object).bmGetFqn());
        }
        if (!monitor.isCanceled() && object instanceof BasicTemplate && ((BasicTemplate)object).getTemplateType() == TemplateType.SPREADSHEET_DOCUMENT && this.parameters.isCollectChildObjects() && this.parameters.isCollectSubResources()) {
            this.waitMoxelDerivedData((BasicTemplate)object, monitor);
        }
        FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)monitor);
        monitor.done();
    }

    private void waitMoxelDerivedData(BasicTemplate template, IProgressMonitor monitor) {
        EObject proxy = (EObject)template.eGet((EStructuralFeature)MdClassPackage.Literals.BASIC_TEMPLATE__TEMPLATE, false);
        URI uri = EcoreUtil.getURI((EObject)proxy);
        String fqn = null;
        if (BmUriUtil.isBmUri((URI)uri)) {
            fqn = BmUriUtil.extractTopObjectFqn((URI)uri);
        } else if (uri.isPlatformResource()) {
            Path path = new Path(uri.trimFragment().toPlatformString(true));
            QualifiedName name = this.qualifiedNameFilePathConverter.getFqn((IPath)path);
            fqn = name.toString();
        }
        if (fqn != null) {
            IProject project = this.resourceLookup.getProject((EObject)template);
            IDerivedDataManager manager = this.derivedDataManagerProvider.get(project);
            try {
                manager.waitComputationExt(Map.of(fqn, List.of(DD_MOXEL_ASYNC_IMPORT_SEGMENT)), DD_WAIT);
            }
            catch (InterruptedException e) {
                MdPlugin.logError(e);
            }
        }
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(this.object), this.addAction);
        }
        return this.context;
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }
}

