/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md;

import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Cube;
import com._1c.g5.v8.dt.metadata.mdclass.DimensionTable;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.metadata.mdclass.Subsystem;
import com._1c.g5.v8.dt.metadata.mdclass.Table;
import com._1c.g5.v8.dt.metadata.mdclass.util.MdClassUtil;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.common.base.Strings;
import com.google.inject.Provider;
import java.util.Optional;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;

public class MdTranslateUtil {
    public static final String FILTER_PREFFIX_RU = "\u041e\u0442\u0431\u043e\u0440.";
    public static final String FILTER_PREFFIX = "Filter.";

    public static String getFilterPreffix(ScriptVariant scriptVariant) {
        boolean isRussian = scriptVariant == ScriptVariant.RUSSIAN;
        return isRussian ? FILTER_PREFFIX_RU : FILTER_PREFFIX;
    }

    public static QualifiedName getFullyQualifiedName(MdObject mdObject, IProjectTranslationProvider translationProvider) {
        EStructuralFeature feature;
        QualifiedName fqn;
        Subsystem parent;
        Provider provider = () -> {
            Optional<String> translation = MdTranslateUtil.getMdObjectNameTranslation(mdObject, translationProvider);
            return translation.orElse(mdObject.getName());
        };
        ModelNameTranslationCache cache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
        String name = cache.getTranslation(EcoreUtil.getURI((EObject)mdObject), provider);
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (mdObject instanceof Configuration) {
            return QualifiedName.create((String)"Configuration");
        }
        if (mdObject instanceof Subsystem) {
            parent = ((Subsystem)mdObject).getParentSubsystem();
            if (parent != null && (fqn = MdTranslateUtil.getFullyQualifiedName((MdObject)parent, translationProvider)) != null) {
                String code = MdClassUtil.getMdClassCode((EModelElement)MdClassPackage.Literals.SUBSYSTEM__SUBSYSTEMS);
                return fqn.append(code).append(name);
            }
        } else if (mdObject instanceof DimensionTable) {
            parent = ((DimensionTable)mdObject).getParentCube();
            if (parent != null && (fqn = MdTranslateUtil.getFullyQualifiedName((MdObject)parent, translationProvider)) != null) {
                String code = MdClassUtil.getMdClassCode((EModelElement)MdClassPackage.Literals.CUBE__DIMENSION_TABLES);
                return fqn.append(code).append(name);
            }
        } else if (mdObject instanceof Cube) {
            parent = ((Cube)mdObject).getParentDataSource();
            if (parent != null && (fqn = MdTranslateUtil.getFullyQualifiedName((MdObject)parent, translationProvider)) != null) {
                String code = MdClassUtil.getMdClassCode((EModelElement)MdClassPackage.Literals.EXTERNAL_DATA_SOURCE__CUBES);
                return fqn.append(code).append(name);
            }
        } else if (mdObject instanceof Table && (parent = ((Table)mdObject).getParentDataSource()) != null && (fqn = MdTranslateUtil.getFullyQualifiedName((MdObject)parent, translationProvider)) != null) {
            String code = MdClassUtil.getMdClassCode((EModelElement)MdClassPackage.Literals.EXTERNAL_DATA_SOURCE__TABLES);
            return fqn.append(code).append(name);
        }
        if ((feature = mdObject.eContainingFeature()) == null) {
            return QualifiedName.create((String[])new String[]{mdObject.eClass().getName(), name});
        }
        String code = MdClassUtil.getMdClassCode((EModelElement)feature);
        return MdTranslateUtil.getFullyQualifiedName(mdObject, name, code, translationProvider);
    }

    public static Optional<String> getMdObjectNameTranslation(MdObject mdObject, IProjectTranslationProvider translationProvider) {
        if (!translationProvider.getProject().isChangeDefaultLanguage()) {
            return Optional.empty();
        }
        return translationProvider.getOptionalTranslation((EObject)mdObject, MdFeatureSettings.Literals.MD_OBJECT__NAME, translationProvider.getProject().getDefaultLanguage());
    }

    private static QualifiedName getFullyQualifiedName(MdObject mdObject, String name, String code, IProjectTranslationProvider translationProvider) {
        if (code == null) {
            return null;
        }
        QualifiedName parentName = MdTranslateUtil.getFullyQualifiedName((MdObject)mdObject.eContainer(), translationProvider);
        if (parentName == null) {
            return null;
        }
        if (parentName.getSegmentCount() == 1) {
            return QualifiedName.create((String)code).append(name);
        }
        return parentName.append(code).append(name);
    }
}

