/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.storage;

import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.md.InternalizeDbViewTermsProvider;
import com.google.common.hash.HashFunction;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class DbViewTermsStorage
implements ITranslationStorageProvider.DictionaryStorage {
    private static final String LANG_CODE_ENG = "en";
    private static final String LANG_CODE_RUS = "ru";
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private InternalizeDbViewTermsProvider dbViewTermsProvider;
    private StorageID id;
    private volatile IProject project;
    private volatile boolean isRussian;
    private volatile boolean initilized;

    public StorageID getId() {
        if (this.id == null) {
            this.id = new StorageID("com.e1c.langtool.v8.dt.md.dbview", "terms");
        }
        return this.id;
    }

    public String getSegment() {
        return this.getId().getSegment();
    }

    public void addValueChangedListener(IStorageValueChangedListener listener) {
    }

    public void removeValueChangedListener(IStorageValueChangedListener listener) {
    }

    public String getTranslation(TranslationKey key, TranslateLanguage language) {
        String translation;
        if (!key.getFeatureSettings().isModel()) {
            return "";
        }
        if ((this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_ENG) || !this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_RUS)) && (translation = this.dbViewTermsProvider.getInternalizeEnumValue(key.getValue(), !this.isRussian())) != null) {
            return translation;
        }
        return "";
    }

    public void setTranslation(TranslationKey key, TranslateLanguage language, String translation, boolean autoSave) {
    }

    public void removeTranslation(TranslationKey key, TranslateLanguage language, boolean autoSave) {
    }

    public void moveTranslation(TranslationKey fromKey, TranslationKey toKey, TranslateLanguage language, boolean autoSave) {
    }

    public ITranslationStorageProvider.Storage.Type getType() {
        return ITranslationStorageProvider.Storage.Type.COMMON;
    }

    public void beginBatchUpdate() {
    }

    public void endBatchUpdate() {
    }

    public void initialize(IProject project) {
        this.project = project;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Map<IFile, byte[]> saveFiles(TranslateLanguage language, HashFunction hashFunction) {
        return null;
    }

    private boolean isRussian() {
        if (!this.initilized) {
            IV8Project v8project = this.v8ProjectManager.getProject(this.project);
            if (v8project == null) {
                return false;
            }
            this.isRussian = v8project.getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            this.initilized = true;
        }
        return this.isRussian;
    }

    public boolean hasKeyForValue(String value, TranslateLanguage language, TranslationKey skipKey) {
        if (skipKey != null && !skipKey.getFeatureSettings().isModel()) {
            return false;
        }
        if (this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_ENG) || !this.isRussian() && language.getLanguageCode().equalsIgnoreCase(LANG_CODE_RUS)) {
            String key = skipKey == null ? null : skipKey.getValue();
            String translation = this.dbViewTermsProvider.getInternalizeEnumValue(value, this.isRussian());
            if (!(translation == null || key != null && key.equalsIgnoreCase(translation))) {
                return true;
            }
        }
        return false;
    }
}

