/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.sync;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.ObjectBelonging;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.md.sync.MdObjectCopier;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConfigurationObjectCopier
extends MdObjectCopier {
    private Configuration sourceRoot;

    public ConfigurationObjectCopier(IProject project, IBmPlatformTransaction transaction, EObject sourceRoot, IProjectTranslationProvider translationProvider, IBmNamespace targetNamespace, Version runtimeVersion) {
        super(project, transaction, sourceRoot, translationProvider, targetNamespace, runtimeVersion);
        this.sourceRoot = (Configuration)sourceRoot;
    }

    protected EObject createCopy(EObject eObject) {
        if (eObject.equals(this.sourceRoot)) {
            this.root = (IBmObject)this.transaction.toTransactionObject((EObject)this.transaction.getTopObjectByFqn(this.targetNamespace, "Configuration"));
            return this.root;
        }
        return super.createCopy(eObject);
    }

    @Override
    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        super.copyContainment(eReference, eObject, copyEObject);
        if (eReference.equals(MdClassPackage.Literals.CONFIGURATION__LANGUAGES)) {
            Object value = copyEObject.eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__LANGUAGES);
            List languages = (List)value;
            this.removeLanguages(languages);
            this.addNewLanguages(languages);
            this.setDefaultLanguage(languages);
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (eReference.equals(MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE) && this.translationProvider.getProject().isChangeDefaultLanguage()) {
            return;
        }
        super.copyReference(eReference, eObject, copyEObject);
    }

    @Override
    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
        if (eAttribute.equals(MdClassPackage.Literals.CONFIGURATION__SCRIPT_VARIANT) && this.translationProvider.getProject().isChangeScriptVariant()) {
            copyEObject.eSet((EStructuralFeature)eAttribute, (Object)this.translationProvider.getProject().getScriptVariant());
        } else {
            super.copyAttribute(eAttribute, eObject, copyEObject);
        }
    }

    private void removeLanguages(List<Language> languages) {
        Iterator<Language> iterator = languages.iterator();
        while (iterator.hasNext()) {
            Language language = iterator.next();
            if (this.getLanguageCodes().contains(language.getLanguageCode()) && !(language instanceof TranslateLanguage)) continue;
            iterator.remove();
        }
    }

    private void addNewLanguages(List<Language> languages) {
        Map allLanguages = this.translationProvider.getProject().getLanguages().stream().collect(Collectors.toMap(Language::getLanguageCode, Function.identity(), (first, second) -> first));
        for (Language language : languages) {
            allLanguages.remove(language.getLanguageCode());
        }
        Language newLanguage = null;
        for (Language language : allLanguages.values()) {
            newLanguage = MdClassFactory.eINSTANCE.createLanguage();
            newLanguage.setObjectBelonging(ObjectBelonging.NATIVE);
            this.copyAttribute(MdClassPackage.Literals.MD_OBJECT__UUID, (EObject)language, (EObject)newLanguage);
            this.copyAttribute(MdClassPackage.Literals.MD_OBJECT__NAME, (EObject)language, (EObject)newLanguage);
            this.copyAttribute(MdClassPackage.Literals.MD_OBJECT__COMMENT, (EObject)language, (EObject)newLanguage);
            this.copyContainment(MdClassPackage.Literals.MD_OBJECT__SYNONYM, (EObject)language, (EObject)newLanguage);
            this.copyAttribute(MdClassPackage.Literals.LANGUAGE__LANGUAGE_CODE, (EObject)language, (EObject)newLanguage);
            languages.add(newLanguage);
        }
    }

    private void setDefaultLanguage(List<Language> languages) {
        if (!this.translationProvider.getProject().isChangeDefaultLanguage() || !(this.root instanceof Configuration)) {
            return;
        }
        String defaultLanguageCode = this.translationProvider.getProject().getDefaultLanguage().getLanguageCode();
        for (Language language : languages) {
            if (!language.getLanguageCode().equals(defaultLanguageCode)) continue;
            ((Configuration)this.root).setDefaultLanguage(language);
            return;
        }
    }
}

