/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.sync;

import com._1c.g5.v8.dt.mcore.DerivedField;
import com._1c.g5.v8.dt.mcore.FieldSource;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com._1c.g5.v8.dt.metadata.mdclass.CharacteristicsDescription;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.md.MdTranslateUtil;
import com.e1c.langtool.v8.dt.md.settings.MdFeatureSettings;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class DataPathFieldTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    private static final String SPLIT_PATTERN = "\\.";
    private static final String PART_SEPARATOR = ".";
    private static final String MINUS_ONE = "-1";

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(MdFeatureSettings.Literals.CHARACTERISTICS_DESCRIPTION__DATA_PATH_FIELD)) {
            return false;
        }
        Object value = object.eGet(stringFeature.getEFeature());
        if (!(value instanceof String)) {
            return false;
        }
        return !((String)value).isEmpty();
    }

    public boolean isSupported(EObject object) {
        return object instanceof CharacteristicsDescription;
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        CharacteristicsDescription description = (CharacteristicsDescription)object;
        String dataPathField = description.getDataPathField();
        if (dataPathField == null) {
            return "";
        }
        if (MINUS_ONE.equals(dataPathField)) {
            return MINUS_ONE;
        }
        String[] splitted = dataPathField.split(SPLIT_PATTERN);
        MdObject tabularType = description.getCharacteristicTypes();
        if (tabularType == null) {
            return "";
        }
        String qualifiedName = MdTranslateUtil.getFullyQualifiedName(tabularType, translationProvider).toString();
        StringBuilder sb = new StringBuilder(qualifiedName);
        EList fields = ((FieldSource)tabularType).getFields();
        Map fieldMap = fields.stream().filter(field -> field instanceof DerivedField).collect(Collectors.groupingBy(NamedElement::getName, Collectors.toList()));
        int i = qualifiedName.split(SPLIT_PATTERN).length;
        while (i < splitted.length) {
            String fieldName = splitted[i];
            List found = fieldMap.getOrDefault(fieldName, Collections.emptyList());
            if (found.isEmpty()) {
                sb.append(PART_SEPARATOR).append(fieldName);
            } else {
                Optional translated = translationProvider.getOptionalTranslation((EObject)found.get(0), McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, language);
                if (translated.isPresent()) {
                    sb.append(PART_SEPARATOR).append((String)translated.get());
                } else {
                    sb.append(PART_SEPARATOR).append(fieldName);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

