/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.sync;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.ReplacebleExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

public class MdPictureSynchronizer
extends ReplacebleExternalPropertySynchronizer {
    private static final String ID = "com._1c.g5.v8.dt.md.MdPicture";
    @Inject
    private IBmModelManager modelManager;

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        IProject project = sourceFile.getProject();
        LinkedHashSet result = Sets.newLinkedHashSet();
        IBmModel model = this.modelManager.getModel(project);
        if (!sourceFile.isAccessible() || model == null || !(session instanceof BmSyncSession)) {
            return result;
        }
        BmSyncSession bmSession = (BmSyncSession)session;
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(sourceFile);
        if (fqn == null || fqn.isEmpty()) {
            return result;
        }
        boolean newTransaction = false;
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(false);
            newTransaction = true;
        }
        try {
            String ownerPath;
            Path path;
            IBmObject owner = transaction.getTopObjectByFqn(fqn.skipLast(1).toString());
            if (owner == null) {
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            owner = transaction.toTransactionObject((EObject)owner);
            IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
            String translatedFqn = this.topObjectFqnGenerator.generateFqn((EObject)owner, translationProvider);
            IPath filePath = null;
            if (translatedFqn != null && !(path = new Path(ownerPath = this.qualifiedNameFilePathConverter.getFilePath(translatedFqn))).isEmpty()) {
                filePath = path.removeLastSegments(1).append(sourceFile.getProjectRelativePath().lastSegment());
            }
            if (filePath == null) {
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IFile targetFile = target.getProject().getFile(filePath);
            IStatus status = this.synchronize(sourceFile, (EObject)owner, target.getProject(), targetFile, bmSession, translationProvider, monitor);
            if (Status.OK_STATUS.equals(status)) {
                result.add(targetFile);
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newTransaction) {
                transaction.rollback();
            }
        }
    }
}

