/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bp.scheme.sync.picture;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalScheme;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeItem;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.metadata.mdclass.BusinessProcess;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.bp.scheme.settings.SchemeFeatureSettings;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.ReplacebleExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

public class SchemePictureSynchronizer
extends ReplacebleExternalPropertySynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.bp.scheme.SchemePicture";
    private static final Pattern GRAPHICAL_SCEME_ELEMENT_PICTURE_PATTERN = Pattern.compile("(?U)^src\\\\\\w+\\\\\\w+\\\\(?:(BusinessProcesses|Templates)\\\\\\w+\\\\)?Items\\\\(?<elem>\\w+)\\\\(?<feature>\\w+)\\.(?<extn>(?i)(?:bmp|dib|rle|gif|jpg|jpeg|png|tif|ico|wmf|emf|zip|picture))$");
    private static final String ELEM_PATTERN_GROUP = "elem";
    @Inject
    private IBmModelManager modelManager;

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (!(session instanceof BmSyncSession)) {
            return result;
        }
        String fileName = String.join((CharSequence)"\\", sourceFile.getProjectRelativePath().segments());
        Matcher matcher = GRAPHICAL_SCEME_ELEMENT_PICTURE_PATTERN.matcher(fileName);
        if (!matcher.find()) {
            return result;
        }
        IBmModel model = this.modelManager.getModel(sourceFile.getProject());
        if (model == null) {
            return result;
        }
        URI uri = BmUriUtil.createTopBmObjectUri((String)sourceFile.getProject().getName(), (String)this.generateFormFqnString(sourceFile));
        boolean newTransaction = false;
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(false);
            newTransaction = true;
        }
        try {
            IBmObject eObject = transaction.getObjectByUri(uri);
            if (eObject instanceof GraphicalScheme || eObject instanceof BusinessProcess) {
                if (!(eObject instanceof GraphicalScheme)) {
                    eObject = (IBmObject)((BusinessProcess)eObject).getFlowchart();
                }
                if (!(eObject instanceof GraphicalScheme)) {
                    LinkedHashSet linkedHashSet = result;
                    return linkedHashSet;
                }
                IProjectTranslationProvider translationProvider = ((BmSyncSession)session).getTranslationProvider();
                String fqn = this.topObjectFqnGenerator.generateFqn((EObject)eObject, translationProvider);
                if (fqn == null) {
                    LinkedHashSet linkedHashSet = result;
                    return linkedHashSet;
                }
                String formPath = this.qualifiedNameFilePathConverter.getFilePath(fqn);
                Path path = new Path(formPath);
                path = path.removeLastSegments(1);
                String elementName = matcher.group(ELEM_PATTERN_GROUP);
                Optional<GraphicalSchemeItem> schemeItem = ((GraphicalScheme)eObject).getItems().stream().filter(item -> elementName.equals(item.getName())).findAny();
                if (schemeItem.isPresent()) {
                    GraphicalSchemeItem item2 = schemeItem.get();
                    TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
                    Optional translation = translationProvider.getOptionalTranslation((EObject)item2, SchemeFeatureSettings.Literals.GRAPHICAL_SCHEME_ITEM__NAME, language);
                    IPath sourcePath = sourceFile.getProjectRelativePath().removeFirstSegments(path.segmentCount());
                    path = path.append(sourcePath.removeLastSegments(2).append(translation.orElse(item2.getName())).append(sourcePath.lastSegment()));
                    IFile targetFile = target.getProject().getFile((IPath)path);
                    IStatus status = this.synchronize(sourceFile, (EObject)item2, target.getProject(), targetFile, (BmSyncSession)session, translationProvider, monitor);
                    if (status.isOK()) {
                        result.add(targetFile);
                    }
                }
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newTransaction) {
                transaction.rollback();
            }
        }
    }

    private String generateFormFqnString(IFile file) {
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(file);
        boolean isTemplate = fqn.getSegments().contains("Template");
        fqn = fqn.skipLast(3);
        if (isTemplate) {
            fqn = fqn.append("Template");
        }
        return fqn.toString();
    }
}

