/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bp.scheme.i18n.extension;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalScheme;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtension;
import com._1c.g5.v8.dt.core.provider.IResourceContentExporterExtensionManager;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.mcore.impl.LocalStringMapEntryImpl;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LifecycleService(name="GraphicalSchemeV8ExporterExtension")
@Singleton
public class GraphicalSchemeV8ExporterExtension
implements IResourceContentExporterExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicalSchemeV8ExporterExtension.class);
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final ITranslatingProjectManager translatingProjectManager;
    private final ITranslationStorageManager storageManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final IFeatureSettingsService featureSettingsService;
    private final IResourceContentExporterExtensionManager resourceContentExporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public GraphicalSchemeV8ExporterExtension(ITranslationFeatureKeyProvider featureKeyProvider, ITranslatingProjectManager translatingProjectManager, ITranslationStorageManager storageManager, IStorageSettingsManager storageSettingsManager, IFeatureSettingsService featureSettingsService, IResourceContentExporterExtensionManager resourceContentExporterExtensionManager) {
        this.featureKeyProvider = featureKeyProvider;
        this.translatingProjectManager = translatingProjectManager;
        this.storageManager = storageManager;
        this.storageSettingsManager = storageSettingsManager;
        this.featureSettingsService = featureSettingsService;
        this.resourceContentExporterExtensionManager = resourceContentExporterExtensionManager;
    }

    public void beforeExport(EObject object, IFile file, Version runtimeVersion) {
        if (!(object instanceof GraphicalScheme)) {
            return;
        }
        this.updateLocalStrings((GraphicalScheme)object, file, false);
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        if (!(clone instanceof GraphicalScheme)) {
            return;
        }
        Collection<ContextTranslationKey> affectedKeys = this.updateLocalStrings((GraphicalScheme)clone, file, true);
        if (!affectedKeys.isEmpty()) {
            IProject project = file.getProject();
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
            List languages = translatingProject.getInterfaceLanguages();
            StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
            if (!(storage instanceof ITranslationStorageProvider.ContextStorage)) {
                return;
            }
            ITranslationStorageProvider.ContextStorage currentStorage = (ITranslationStorageProvider.ContextStorage)storage;
            for (TranslateLanguage language : languages) {
                Map hashes = currentStorage.saveFiles(affectedKeys, language, Hashing.sha256());
                if (hashes.isEmpty()) continue;
                hashes.forEach((iFile, hash) -> exportedExtraFiles.put((IFile)iFile, (byte[])hash));
            }
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.resourceContentExporterExtensionManager.registerExtension((IResourceContentExporterExtension)this);
    }

    private Collection<ContextTranslationKey> updateLocalStrings(GraphicalScheme object, IFile file, boolean exportMode) {
        LOGGER.trace("Processing file: {}", (Object)file);
        IProject project = file.getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return Collections.emptySet();
        }
        try {
            String defaultLanguageCode = translatingProject.getDefaultLanguage().getLanguageCode();
            List languages = translatingProject.getInterfaceLanguages();
            StorageID storageId = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId();
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageId);
            if (!(storage instanceof ITranslationStorageProvider.ContextStorage)) {
                Set<ContextTranslationKey> set = Collections.emptySet();
                return set;
            }
            ITranslationStorageProvider.ContextStorage currentStorage = (ITranslationStorageProvider.ContextStorage)storage;
            TreeIterator iterator = object.eAllContents();
            LinkedHashSet objectToUpdate = Sets.newLinkedHashSet();
            while (iterator.hasNext()) {
                EObject content = (EObject)iterator.next();
                if (!(content instanceof LocalStringMapEntryImpl)) continue;
                objectToUpdate.add(new Pair((Object)content.eContainer(), (Object)content.eContainingFeature()));
            }
            HashSet<ContextTranslationKey> affectedKeys = new HashSet<ContextTranslationKey>();
            for (Pair entry : objectToUpdate) {
                this.updateLocalString((EObject)entry.getKey(), (EStructuralFeature)entry.getValue(), defaultLanguageCode, file, languages, currentStorage, affectedKeys, exportMode);
            }
            HashSet<ContextTranslationKey> hashSet = affectedKeys;
            return hashSet;
        }
        finally {
            LOGGER.trace("Done processing file {}", (Object)file);
        }
    }

    private void updateLocalString(EObject clone, EStructuralFeature feature, String defaultLanguageCode, IFile currentFile, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage currentStorage, Collection<ContextTranslationKey> affectedKeys, boolean exportMode) {
        EFeatureSettings featureSettings = this.featureSettingsService.getSettings(feature, clone);
        EMap localStringMap = (EMap)clone.eGet(feature);
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey(clone, (FeatureSettings)featureSettings);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(currentFile, featureKey, (FeatureSettings)featureSettings, (String)localStringMap.get((Object)defaultLanguageCode));
        affectedKeys.add((ContextTranslationKey)contextKey);
        for (TranslateLanguage language : languages) {
            String languageCode = language.getLanguageCode();
            if (localStringMap.containsKey((Object)languageCode)) {
                currentStorage.setTranslation((ContextTranslationKey)contextKey, language, (String)localStringMap.get((Object)languageCode), !exportMode);
            } else {
                currentStorage.removeTranslation((ContextTranslationKey)contextKey, language, !exportMode);
            }
            localStringMap.removeKey((Object)languageCode);
        }
    }
}

