/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.bp.scheme.i18n.xml.extension;

import com._1c.g5.v8.dt.bp.scheme.model.GraphicalScheme;
import com._1c.g5.v8.dt.bp.scheme.xml.serialization.export.BpSchemeExportUtil;
import com._1c.g5.v8.dt.export.ExportException;
import com._1c.g5.v8.dt.export.IExportArtifactBuilder;
import com._1c.g5.v8.dt.export.xml.IExportContext;
import com._1c.g5.v8.dt.export.xml.IExporter;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtension;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtensionManager;
import com._1c.g5.v8.dt.metadata.mdclass.BasicTemplate;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.TemplateType;
import com._1c.g5.v8.dt.xml.LineFeedConverter;
import com._1c.g5.v8.dt.xml.XmlStreamUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.e1c.langtool.v8.dt.internal.bp.scheme.SchemePlugin;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LifecycleService(name="GraphicalSchemeXmlExporterExtension")
@Singleton
public class GraphicalSchemeXmlExporterExtension
implements IXmlExporterExtension {
    private static final byte[] GRAPHICAL_SCHEMA_TAG = "<GraphicalSchema".getBytes(StandardCharsets.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphicalSchemeXmlExporterExtension.class);
    private final IDocumentProcessingSettingsManager documentProcessingSettingsManager;
    private final ITranslatingProjectManager translatingProjectManager;
    private final IXmlExporterExtensionManager xmlExporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public GraphicalSchemeXmlExporterExtension(IDocumentProcessingSettingsManager documentProcessingSettingsManager, ITranslatingProjectManager translatingProjectManager, IXmlExporterExtensionManager xmlExporterExtensionManager) {
        this.documentProcessingSettingsManager = documentProcessingSettingsManager;
        this.translatingProjectManager = translatingProjectManager;
        this.xmlExporterExtensionManager = xmlExporterExtensionManager;
    }

    public void copyTemplateWithLineFeedConversion(IExporter exporter, EObject eObject, IExportContext exportContext, IExportArtifactBuilder artifactBuilder, Path source, Path target, LineFeedConverter.ConvertOption ... options) throws ExportException {
        GraphicalScheme graphicalScheme = null;
        if (eObject instanceof GraphicalScheme) {
            graphicalScheme = (GraphicalScheme)eObject;
            LOGGER.debug("Exporting Flowchart to Platform XML format.");
        } else {
            graphicalScheme = (GraphicalScheme)((BasicTemplate)eObject).getTemplate();
            LOGGER.debug("Exporting Graphical Scheme to Platform XML format.");
            LOGGER.debug("Template name: {}", (Object)((MdObject)eObject).getName());
        }
        this.documentProcessingSettingsManager.lockDocumentSaveProcessing();
        try {
            LOGGER.debug("LineFeedConverter.convert(Path, Path)");
            LOGGER.debug("Source: {}", (Object)source);
            LOGGER.debug("Target: {}", (Object)target);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                BpSchemeExportUtil.export((GraphicalScheme)graphicalScheme, (OutputStream)outputStream, (IExportContext)exportContext);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                Throwable throwable = null;
                Object var12_14 = null;
                try (BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);){
                    Throwable throwable2 = null;
                    Object var15_19 = null;
                    try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(artifactBuilder.newOutputStream(target));){
                        byte[] bytes = XmlStreamUtils.readHeadIncludeVersion((InputStream)bufferedInput, (byte[])GRAPHICAL_SCHEMA_TAG, (String)exportContext.getXmlFormatVersion());
                        LineFeedConverter.convert((InputStream)new ByteArrayInputStream(bytes), (OutputStream)bufferedOutput, (LineFeedConverter.ConvertOption[])options);
                        LineFeedConverter.ConvertOption[] newOptions = Arrays.stream(options).filter(Predicate.not(arg_0 -> LineFeedConverter.ConvertOption.WRITE_BOM.equals(arg_0))).collect(Collectors.toList()).toArray(new LineFeedConverter.ConvertOption[0]);
                        LineFeedConverter.convert((InputStream)bufferedInput, (OutputStream)bufferedOutput, (LineFeedConverter.ConvertOption[])newOptions);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException | XMLStreamException e) {
                SchemePlugin.logError(e);
            }
        }
        finally {
            this.documentProcessingSettingsManager.unlockDocumentSaveProcessing();
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.xmlExporterExtensionManager.registerExtension((IXmlExporterExtension)this);
    }

    public boolean overridesTemplateCopying(EObject eObject, IExportContext exportContext) {
        BasicTemplate template;
        if (eObject instanceof BasicTemplate && (template = (BasicTemplate)eObject).getTemplateType() == TemplateType.GRAPHICAL_SCHEMA) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(exportContext.getExportProject());
            return translatingProject.isTranslating();
        }
        if (eObject instanceof GraphicalScheme) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(exportContext.getExportProject());
            return translatingProject.isTranslating();
        }
        return false;
    }
}

