/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter;

import com.e1c.langtool.converter.IConverterEngine;
import com.e1c.langtool.internal.converter.Messages;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AsyncConverter {
    private static final long ASYNC_CONVERTER_DELAY = 100L;
    private final IConverterEngine engine;
    private final Map<IProject, Map<IProject, IProject>> converted = new ConcurrentHashMap<IProject, Map<IProject, IProject>>();
    private final ConverterJob asyncConvert = new ConverterJob();

    public AsyncConverter(IConverterEngine engine) {
        this.engine = engine;
    }

    public void scheduleCompute() {
        this.asyncConvert.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToConvert(IProject project, IProject sourceLangProject, IProject targetLangProject) {
        Map<IProject, Map<IProject, IProject>> map = this.converted;
        synchronized (map) {
            this.converted.computeIfAbsent(project, p -> new ConcurrentHashMap()).put(sourceLangProject, targetLangProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanQueue(IProject project) {
        Map<IProject, Map<IProject, IProject>> map = this.converted;
        synchronized (map) {
            Map<IProject, IProject> queue = this.converted.get(project);
            if (queue != null) {
                queue.clear();
            }
        }
    }

    private class ConverterJob
    extends Job {
        public ConverterJob() {
            super(Messages.AsyncConverter_Converter);
        }

        public boolean belongsTo(Object family) {
            return "Converter".equals(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Map<IProject, Map<IProject, IProject>> map = AsyncConverter.this.converted;
            synchronized (map) {
                for (Map.Entry<IProject, Map<IProject, IProject>> entry : AsyncConverter.this.converted.entrySet()) {
                    IProject project = entry.getKey();
                    if (!project.isAccessible()) continue;
                    Iterator<Map.Entry<IProject, IProject>> iterator = entry.getValue().entrySet().iterator();
                    while (iterator.hasNext()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        Map.Entry<IProject, IProject> entry2 = iterator.next();
                        IProject sourceProject = entry2.getKey();
                        IProject targetProject = entry2.getValue();
                        iterator.remove();
                        this.convert(project, sourceProject, targetProject, monitor);
                    }
                    AsyncConverter.this.cleanQueue(project);
                }
                return Status.OK_STATUS;
            }
        }

        private void convert(IProject project, IProject sourceProject, IProject targetProject, IProgressMonitor monitor) {
            AsyncConverter.this.engine.convert(project, sourceProject, targetProject, monitor);
        }
    }
}

