/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.internal.converter.AsyncConverter;
import com.e1c.langtool.internal.converter.db.ConvertedValues;
import com.e1c.langtool.internal.converter.db.ProjectConverterStorage;
import com.e1c.langtool.platform.TranslateLanguage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ConverterManagerImpl
implements IConverterManager {
    private static final String VALUE_NAME = ".Value";
    private static final String NSTR_NAME = "NStr.";
    private static final String LINES_NAME = ".Lines";
    private final IProject project;
    private final ProjectConverterStorage storage;
    private final AsyncConverter converter;
    private final TranslateLanguage language;

    public ConverterManagerImpl(IProject project, ProjectConverterStorage storage, AsyncConverter converter, TranslateLanguage language) {
        this.project = project;
        this.storage = storage;
        this.converter = converter;
        this.language = language;
    }

    @Override
    public void runConverter(IProject sourceLangProject, IProject targetLangProject) {
        this.converter.addToConvert(this.project, sourceLangProject, targetLangProject);
        this.converter.scheduleCompute();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public TranslateLanguage getLanguage() {
        return this.language;
    }

    @Override
    public Map<String, String> getConvertedValues(IPath path) {
        String lastSegment = ConverterManagerImpl.removeUuidAndLanguage(path.removeFileExtension().lastSegment());
        ConvertedValues val = this.storage.getValues(path.removeLastSegments(1).append(lastSegment));
        if (val.getValues().isEmpty()) {
            val = this.storage.getValues(path.removeLastSegments(1));
        }
        return val.getValues();
    }

    @Override
    public IPath getConvertedKey(IPath path) {
        IPath basePath = path.removeLastSegments(1);
        IPath projectPath = this.project.getFullPath();
        String stringPath = this.storage.getTargetKey(basePath);
        if (!stringPath.isEmpty()) {
            return projectPath.append(stringPath).append(this.getSuffix(path)).makeRelativeTo(projectPath);
        }
        return path;
    }

    @Override
    public void updateConvertedValues(IPath path, FeatureKey sourceKey, FeatureKey targetKey) {
        String targetFk;
        String sourceFk = this.formatFeatureKey(sourceKey);
        if (sourceFk.equals(targetFk = this.formatFeatureKey(targetKey))) {
            return;
        }
        IPath basePath = this.computeValuesPath(path);
        basePath = this.computeValuesPath(path).removeLastSegments(1).append(ConverterManagerImpl.removeUuidAndLanguage(basePath.lastSegment()));
        this.storage.collectValues(basePath, new ConvertedValues(Map.of(sourceFk, targetFk)));
    }

    @Override
    public void updateStringLiteralParams(IPath path, String name, String translation) {
        IPath basePath = this.computeValuesPath(path);
        this.storage.collectValues(basePath, new ConvertedValues(Map.of(name, translation)));
    }

    @Override
    public void updateConvertedKey(IPath path, IPath targetPath) {
        IPath p1 = path.removeLastSegments(1);
        IPath p2 = targetPath.removeLastSegments(1);
        this.storage.putTargetKey(p1, p2.toString());
        IPath basePath = this.computeValuesPath(path);
        this.storage.putValues(basePath);
    }

    @Override
    public void removeConvertedValues(IPath path) {
        IPath basePath = this.computeValuesPath(path);
        this.storage.removeValues(basePath);
    }

    @Override
    public void removeConvertedKey(IPath path) {
        IPath basePath = path.removeLastSegments(1);
        this.storage.removeTargetKey(basePath);
    }

    @Override
    public void remove(IPath path) {
        this.removeConvertedKey(path);
        this.removeConvertedValues(path);
    }

    private static String removeUuidAndLanguage(String input) {
        String regexUuid = "_[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}";
        Pattern patternUuid = Pattern.compile(regexUuid);
        Matcher matcherUuid = patternUuid.matcher(input);
        String cleanedString = matcherUuid.replaceAll("");
        String regexLanguage = "_[a-zA-Z]{2}$";
        Pattern patternLanguage = Pattern.compile(regexLanguage);
        Matcher matcherLanguage = patternLanguage.matcher(cleanedString);
        cleanedString = matcherLanguage.replaceAll("");
        return cleanedString;
    }

    private IPath computeValuesPath(IPath path) {
        if (path.getFileExtension() != null && path.getFileExtension().equals("mdo")) {
            return path.removeLastSegments(1);
        }
        return path.removeFileExtension();
    }

    private String formatFeatureKey(FeatureKey featureKey) {
        List<TokenPair> tokenPairs = List.of(new TokenPair(NSTR_NAME, LINES_NAME), new TokenPair(NSTR_NAME, VALUE_NAME));
        return this.escapeSpacesBetweenTokens(featureKey.toString(), tokenPairs);
    }

    private String escapeSpacesBetweenTokens(String input, List<TokenPair> tokenPairs) {
        for (TokenPair pair : tokenPairs) {
            String startToken = pair.getStartToken();
            String endToken = pair.getEndToken();
            int startIndex = input.indexOf(startToken);
            int endIndex = input.lastIndexOf(endToken);
            if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex || endIndex + endToken.length() != input.length()) continue;
            String substringToEscape = input.substring(startIndex += startToken.length(), endIndex);
            Map<Character, String> escapeMap = this.createEscapeMap();
            StringBuilder escapedSubstring = new StringBuilder();
            char[] cArray = substringToEscape.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (escapeMap.containsKey(Character.valueOf(c))) {
                    escapedSubstring.append(escapeMap.get(Character.valueOf(c)));
                } else {
                    escapedSubstring.append(c);
                }
                ++n2;
            }
            return input.substring(0, startIndex) + escapedSubstring.toString() + input.substring(endIndex);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == ' ' && (i == 0 || input.charAt(i - 1) != '\\')) {
                result.append("\\ ");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private Map<Character, String> createEscapeMap() {
        HashMap<Character, String> escapeMap = new HashMap<Character, String>();
        escapeMap.put(Character.valueOf(' '), "\\ ");
        escapeMap.put(Character.valueOf('.'), "\\.");
        escapeMap.put(Character.valueOf('\n'), "\\n");
        escapeMap.put(Character.valueOf('\t'), "\\t");
        escapeMap.put(Character.valueOf(':'), "\\:");
        escapeMap.put(Character.valueOf('!'), "\\!");
        escapeMap.put(Character.valueOf('='), "\\=");
        escapeMap.put(Character.valueOf('\\'), "\\\\");
        escapeMap.put(Character.valueOf('#'), "\\#");
        return escapeMap;
    }

    private String getSuffix(IPath path) {
        return path.lastSegment();
    }

    private static class TokenPair {
        private final String startToken;
        private final String endToken;

        public TokenPair(String startToken, String endToken) {
            this.startToken = startToken;
            this.endToken = endToken;
        }

        public String getStartToken() {
            return this.startToken;
        }

        public String getEndToken() {
            return this.endToken;
        }
    }
}

