/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter.db;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.internal.converter.ConverterPlugin;
import com.e1c.langtool.internal.converter.db.ConvertedValues;
import com.e1c.langtool.internal.converter.db.ConvertedValuesSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IStatus;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public abstract class ConverterStorage {
    private static final int CACHE_SIZE = 0x4000000;
    private static final String VERSION_KEY = "version";
    private static final int STORAGE_VERSION = 3;
    private final ReadWriteLock initLock = new ReentrantReadWriteLock(false);
    private volatile boolean initialized;
    private final File dbFile;
    private DB db;
    private Map<Long, ConvertedValues> convertedValue;

    protected ConverterStorage(File dbFile) {
        this.dbFile = dbFile;
    }

    public ConvertedValues getValues(long id) {
        this.checkOrOpen();
        return this.convertedValue.get(id);
    }

    public ConvertedValues putValues(long id, ConvertedValues values) {
        this.checkOrOpen();
        return this.convertedValue.put(id, values);
    }

    public ConvertedValues removeValues(long id) {
        this.checkOrOpen();
        return this.convertedValue.remove(id);
    }

    public void open() {
        if (this.initialized) {
            return;
        }
        this.initLock.writeLock().lock();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(ConverterStorage.class.getClassLoader());
                this.doOpen();
                this.initialized = true;
            }
            catch (IOException e) {
                ConverterPlugin.logError(e);
                Thread.currentThread().setContextClassLoader(loader);
                this.initLock.writeLock().unlock();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            this.initLock.writeLock().unlock();
        }
    }

    public void close() {
        this.initLock.writeLock().lock();
        try {
            this.doClose();
            this.initialized = false;
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    public void delete() {
        this.initLock.writeLock().lock();
        try {
            this.close();
            TranslationUtils.cleanUpMabDbFiles((File)this.dbFile);
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    protected void afterOpenDb(DB db) {
    }

    protected void beforeClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOrOpen() {
        this.initLock.readLock().lock();
        try {
            if (this.initialized) {
                return;
            }
        }
        finally {
            this.initLock.readLock().unlock();
        }
        this.initLock.writeLock().lock();
        try {
            ConverterStorage converterStorage = this;
            synchronized (converterStorage) {
                block20: {
                    if (!this.initialized) break block20;
                    return;
                }
                try {
                    this.open();
                }
                catch (Exception e) {
                    String message = MessageFormat.format("Restart storage because cannot open file: {0}", this.dbFile);
                    IStatus status = ConverterPlugin.createErrorStatus(message, e);
                    ConverterPlugin.log(status);
                    try {
                        this.close();
                        this.delete();
                        this.open();
                    }
                    catch (Exception e2) {
                        String errorMsg = "Error occurred while attempting to restart storage after failed open.";
                        ConverterPlugin.logError(errorMsg, e2);
                    }
                }
                if (!this.initialized) {
                    try {
                        this.delete();
                    }
                    catch (Exception e2) {
                        String errorMsg = "Failed to delete incomplete storage file during initialization.";
                        ConverterPlugin.logError(errorMsg, e2);
                    }
                }
            }
        }
        finally {
            this.initLock.writeLock().unlock();
        }
    }

    private void doClose() {
        this.beforeClose();
        this.convertedValue = null;
        if (this.db != null && !this.db.isClosed()) {
            this.db.close();
        }
        this.db = null;
    }

    private void doOpen() throws IOException {
        try {
            Files.createDirectories(this.dbFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            ConverterPlugin.logError(e);
            throw e;
        }
        this.db = this.openDb(this.dbFile);
        Atomic.Integer storageVersion = this.db.getAtomicInteger(VERSION_KEY);
        if (storageVersion.get() > 0 && storageVersion.get() != 3) {
            this.delete();
            this.db = this.openDb(this.dbFile);
            storageVersion = this.db.getAtomicInteger(VERSION_KEY);
        }
        storageVersion.set(3);
        ConvertedValuesSerializer valueSerializer = new ConvertedValuesSerializer();
        this.convertedValue = this.db.createTreeMap("convertedValues").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer((Serializer)valueSerializer).valuesOutsideNodesEnable().counterEnable().makeOrGet();
        this.afterOpenDb(this.db);
    }

    private DB openDb(File file) {
        return DBMaker.newFileDB((File)file).transactionDisable().closeOnJvmShutdown().cacheLRUEnable().cacheSize(0x4000000).snapshotEnable().mmapFileEnableIfSupported().make();
    }
}

