/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.converter.db;

import com.e1c.langtool.internal.converter.db.ConverterStorage;
import java.io.File;
import java.util.Map;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.Serializer;

public class TargetKeyStorage
extends ConverterStorage {
    private Map<Long, String> targetKeys;

    public TargetKeyStorage(File dbFile) {
        super(dbFile);
    }

    public String getTargetKey(long id) {
        this.checkOrOpen();
        return this.targetKeys.get(id);
    }

    public String putTargetKey(long id, String data) {
        this.checkOrOpen();
        return this.targetKeys.putIfAbsent(id, data);
    }

    public String removeTargetKey(long id) {
        this.checkOrOpen();
        return this.targetKeys.remove(id);
    }

    @Override
    protected void afterOpenDb(DB db) {
        this.targetKeys = db.createTreeMap("targetKeys").keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).valueSerializer(Serializer.STRING).makeOrGet();
    }

    @Override
    protected void beforeClose() {
        this.targetKeys = null;
        super.beforeClose();
    }
}

