/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db;

import com.e1c.langtool.history.db.IProjectTranslationStorage;

public final class GroupedTranslation
implements IProjectTranslationStorage.IGroupedTranslation {
    private final String translation;
    private final long count;

    public GroupedTranslation(String translatedValue, long count) {
        if (translatedValue == null) {
            throw new IllegalArgumentException("Translation value must not be null.");
        }
        if (count < 1L) {
            throw new IllegalArgumentException("The number translations must be positive value.");
        }
        this.translation = translatedValue;
        this.count = count;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public String getValue() {
        return this.translation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (this.translation == null ? 0 : this.translation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupedTranslation other = (GroupedTranslation)obj;
        if (this.count != other.count) {
            return false;
        }
        return !(this.translation == null ? other.translation != null : !this.translation.equals(other.translation));
    }

    public String toString() {
        return "GroupedTranslation [translation=" + this.translation + ", count=" + this.count + "]";
    }
}

