/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db.pagination;

import com.e1c.langtool.history.db.pagination.IPageable;

public final class PageRequest
implements IPageable {
    private final int number;
    private final int size;

    public static PageRequest first(int size) {
        return new PageRequest(1, size);
    }

    public static PageRequest of(int number, int size) {
        return new PageRequest(number, size);
    }

    private PageRequest(int number, int size) {
        if (number < 1) {
            throw new IllegalArgumentException("The page number must not be less then one");
        }
        if (size < 1) {
            throw new IllegalArgumentException("The page size must be posittive");
        }
        this.number = number;
        this.size = size;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public IPageable getNext() {
        return new PageRequest(this.number + 1, this.size);
    }

    @Override
    public IPageable getPrevious() {
        if (this.number == 0) {
            return this;
        }
        return new PageRequest(this.number - 1, this.size);
    }
}

