/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db.query;

import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.db.query.IOperation;
import com.e1c.langtool.history.db.query.Operation;

public final class ExpressionBuilder {
    private IExpression head;

    private ExpressionBuilder(IExpression expression) {
        this.head = expression;
    }

    public static IExpression and(IExpression exp1, IExpression exp2) {
        return new Operation(exp1, IOperation.BoolOp.AND, exp2);
    }

    public static ExpressionBuilder where(IExpression expression) {
        return new ExpressionBuilder(expression);
    }

    public ExpressionBuilder and(IExpression expression) {
        this.insertNode(expression, IOperation.BoolOp.AND);
        return this;
    }

    public ExpressionBuilder or(IExpression expression) {
        this.insertNode(expression, IOperation.BoolOp.OR);
        return this;
    }

    public ExpressionBuilder andNot(IExpression expression) {
        this.insertNodeWithNot(expression, IOperation.BoolOp.AND);
        return this;
    }

    public ExpressionBuilder orNot(IExpression expression) {
        this.insertNodeWithNot(expression, IOperation.BoolOp.OR);
        return this;
    }

    public IExpression build() {
        return this.head;
    }

    private void insertNode(IExpression expression, IOperation.BoolOp op) {
        this.head = new Operation(expression, op, this.head);
    }

    private void insertNodeWithNot(IExpression expression, IOperation.BoolOp op) {
        this.head = new Operation(new Operation(null, IOperation.BoolOp.NOT, expression), op, this.head);
    }
}

