/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.history.db.query;

import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.db.query.IExpressionVisitor;
import com.e1c.langtool.history.db.query.IOperation;
import java.util.Optional;

public final class Operation
implements IOperation {
    private final Optional<IExpression> left;
    private final IOperation.BoolOp op;
    private final Optional<IExpression> right;

    public Operation(IExpression left, IOperation.BoolOp op, IExpression right) {
        this.left = Optional.ofNullable(left);
        this.op = op;
        this.right = Optional.ofNullable(right);
    }

    @Override
    public void accept(IExpressionVisitor visitor) {
        visitor.visitOperation(this);
    }

    @Override
    public Optional<IExpression> getLeft() {
        return this.left;
    }

    @Override
    public Optional<IExpression> getRight() {
        return this.right;
    }

    @Override
    public IOperation.BoolOp getOperator() {
        return this.op;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + this.getChildHashCode(this.left);
        result = 31 * result + this.getChildHashCode(this.right);
        return result;
    }

    private int getChildHashCode(Optional<IExpression> expression) {
        return expression.map(expr -> {
            if (expr instanceof IOperation) {
                return ((IOperation)expr).getOperator().hashCode();
            }
            if (expr instanceof ICriteria) {
                return ((ICriteria)expr).hashCode();
            }
            return 0;
        }).orElse(0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        if (other.getOperator() != this.op) {
            return false;
        }
        if (other.getLeft().isPresent() != this.getLeft().isPresent()) {
            return false;
        }
        if (other.getRight().isPresent() != this.getRight().isPresent()) {
            return false;
        }
        boolean isLeftEqual = this.left.map(exp -> exp.equals(other.getLeft().get())).orElse(true);
        if (!isLeftEqual) {
            return false;
        }
        return other.getRight().map(exp -> exp.equals(this.right.get())).orElse(true);
    }
}

