/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.db.service;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.db.query.IExpressionVisitor;
import com.e1c.langtool.history.db.query.IOperation;
import com.e1c.langtool.internal.history.db.entity.Language;
import com.e1c.langtool.internal.history.db.entity.Project;
import com.e1c.langtool.internal.history.db.entity.Translation;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public final class ExpressionToPredicateVisitor
implements IExpressionVisitor {
    private IContext context;
    private Predicate predicate;

    public ExpressionToPredicateVisitor(IContext context) {
        this.context = context;
    }

    @Override
    public void visitCriteria(ICriteria expression) {
        this.predicate = this.createPredicate(expression, this.context);
    }

    @Override
    public void visitOperation(IOperation operation) {
        IExpression rightExp = operation.getRight().orElseThrow(() -> new HistoryDataBaseException("The right expression of the operation must be presenet"));
        CriteriaBuilder cb = this.context.getCriteriaBuilder();
        if (!operation.getLeft().isPresent()) {
            rightExp.accept(this);
            this.predicate = cb.not((Expression)this.predicate);
        } else {
            IExpression leftExp = operation.getLeft().get();
            leftExp.accept(this);
            Predicate leftPredicate = this.predicate;
            rightExp.accept(this);
            Predicate rightPredicate = this.predicate;
            this.predicate = operation.getOperator() == IOperation.BoolOp.AND ? cb.and((Expression)leftPredicate, (Expression)rightPredicate) : cb.or((Expression)leftPredicate, (Expression)rightPredicate);
        }
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    private Predicate createPredicate(ICriteria criteria, IContext context) {
        return (switch (criteria.getOperator()) {
            case ICriteria.CompareOp.LIKE -> p -> context.getCriteriaBuilder().like((Expression)p, (String)criteria.getValue());
            case ICriteria.CompareOp.EQUAL -> p -> context.getCriteriaBuilder().equal((Expression)p, criteria.getValue());
            case ICriteria.CompareOp.LIKE_IN_ANY_CASE -> p -> context.getCriteriaBuilder().equal((Expression)p, (Object)StringUtils.nameToText((String)criteria.getValue().toString()));
            default -> throw new HistoryDataBaseException("Operation " + String.valueOf((Object)criteria.getOperator()) + " is not supported.");
        }).apply(switch (criteria.getField()) {
            case ICriteria.Field.VALUE -> {
                if (criteria.getOperator() == ICriteria.CompareOp.LIKE_IN_ANY_CASE) {
                    yield context.getTranslationRoot().get("normalizedvalue");
                }
                yield context.getTranslationRoot().get("value");
            }
            case ICriteria.Field.LANGUAGE -> context.getLanguage().get("code");
            case ICriteria.Field.PROJECT_NAME -> context.getProject().get("name");
            case ICriteria.Field.FEATURE_KEY -> context.getTranslationRoot().get("featureKey");
            case ICriteria.Field.FEATURE_NAME -> context.getTranslationRoot().get("featureName");
            case ICriteria.Field.OWNER -> context.getTranslationRoot().get("resourceId");
            case ICriteria.Field.STORAGE_ID -> context.getStorage().get("storageId");
            case ICriteria.Field.CONTEXT -> context.getTranslationRoot().get("context");
            case ICriteria.Field.TRANSLATION -> context.getTranslationRoot().get("translatedValue");
            default -> throw new HistoryDataBaseException("Service doesn't support " + String.valueOf((Object)criteria.getField()) + " field");
        });
    }

    public static class Context
    implements IContext {
        private Root<Translation> translationRoot;
        private CriteriaQuery<?> translationQuery;
        private Join<Translation, Project> projects;
        private Join<Translation, Language> languages;
        private Join<Translation, Language> storages;
        private CriteriaBuilder criteriaBuilder;

        public Context(CriteriaQuery<?> translationQuery, CriteriaBuilder criteriaBuilder) {
            this.translationQuery = translationQuery;
            this.criteriaBuilder = criteriaBuilder;
        }

        @Override
        public Root<Translation> getTranslationRoot() {
            if (this.translationRoot == null) {
                this.translationRoot = this.translationQuery.from(Translation.class);
            }
            return this.translationRoot;
        }

        @Override
        public Join<Translation, Project> getProject() {
            if (this.projects == null) {
                this.projects = this.join("project");
            }
            return this.projects;
        }

        @Override
        public Join<Translation, Language> getLanguage() {
            if (this.languages == null) {
                this.languages = this.join("language");
            }
            return this.languages;
        }

        @Override
        public Join<Translation, Language> getStorage() {
            if (this.storages == null) {
                this.storages = this.join("storage");
            }
            return this.storages;
        }

        @Override
        public CriteriaBuilder getCriteriaBuilder() {
            return this.criteriaBuilder;
        }

        private <T> Join<Translation, T> join(String column) {
            return this.getTranslationRoot().join(column);
        }
    }

    public static interface IContext {
        public CriteriaBuilder getCriteriaBuilder();

        public Root<Translation> getTranslationRoot();

        public Join<Translation, Project> getProject();

        public Join<Translation, Language> getLanguage();

        public Join<Translation, Language> getStorage();
    }
}

