/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.db.service;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.history.db.Context;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.db.query.IExpressionVisitor;
import com.e1c.langtool.history.db.query.IOperation;

public class ExpressionToSqlVisitor
implements IExpressionVisitor {
    private QueryContext queryContext = new QueryContext();
    private StringBuilder sb = new StringBuilder();

    @Override
    public void visitCriteria(ICriteria expression) {
        this.sb.append(this.createPredicate(expression, this.queryContext));
    }

    @Override
    public void visitOperation(IOperation operation) {
        IExpression rightExp = operation.getRight().orElseThrow(() -> new HistoryDataBaseException("The right expression of the operation must be presenet"));
        if (!operation.getLeft().isPresent()) {
            this.addSubExpression("NOT (", () -> rightExp.accept(this), ")");
        } else {
            IExpression leftExp = operation.getLeft().get();
            this.addSubExpression("(", () -> rightExp.accept(this), ")");
            this.sb.append(" ").append(operation.getOperator().name()).append(" ");
            this.addSubExpression("(", () -> leftExp.accept(this), ")");
        }
    }

    public ISqlQuery getQuery() {
        String transWhere;
        String transFrom;
        String predicate = this.sb.toString();
        String select = "trans.translatedValue, count(trans.id)";
        StringBuilder from = new StringBuilder();
        StringBuilder where = new StringBuilder();
        String value = "";
        if (this.queryContext.getTranslatingValue() != null) {
            value = StringUtils.nameToText((String)this.queryContext.getTranslatingValue());
            transFrom = String.format("FT_SEARCH_DATA('%s', 0, 0) ft, Translation trans", value);
            transWhere = "ft.table = 'TRANSLATION' AND trans.id=ft.keys[0]";
        } else {
            transFrom = "Translation trans";
            transWhere = "(TRUE)";
        }
        from.append(transFrom);
        where.append(transWhere);
        if (this.queryContext.isProjectUsed()) {
            from.append(" JOIN Project proj on (trans.project_id = proj.id)");
        }
        if (this.queryContext.isLanguageUsed()) {
            from.append(" JOIN Language lang on (trans.language_id = lang.id)");
        }
        if (this.queryContext.isStorageUsed()) {
            from.append(" JOIN Storage stor on (trans.storage_id = stor.id)");
        }
        where.append(" AND ").append(predicate).append(" GROUP BY trans.translatedValue");
        return new SqlQuery(select, from.toString(), where.toString());
    }

    private String escapeSymbols(String text) {
        return text.replace("'", "''");
    }

    private void addSubExpression(String prefix, Runnable branchCreator, String postfix) {
        this.sb.append(prefix);
        int len = this.sb.length();
        branchCreator.run();
        if (len == this.sb.length()) {
            throw new IllegalArgumentException("Any expression branch can't be empty. Check that all nodes of the given expression call a visitor in accept() method.");
        }
        this.sb.append(postfix);
    }

    private String createPredicate(ICriteria criteria, QueryContext context) {
        Object val;
        String path;
        switch (criteria.getField()) {
            case VALUE: {
                path = criteria.getOperator() != ICriteria.CompareOp.LIKE_IN_ANY_CASE ? "trans.value" : "trans.normalizedvalue";
                context.setTranslatingValue(this.escapeSymbols(criteria.getValue().toString()));
                break;
            }
            case LANGUAGE: {
                path = "lang.code";
                context.setLanguageUsed();
                break;
            }
            case PROJECT_NAME: {
                path = "proj.name";
                context.setProjectUsed();
                break;
            }
            case FEATURE_KEY: {
                path = "trans.featureKey";
                break;
            }
            case FEATURE_NAME: {
                path = "trans.featureName";
                break;
            }
            case OWNER: {
                path = "trans.resourceId";
                break;
            }
            case STORAGE_ID: {
                path = "stor.storageId";
                context.setStorageUsed();
                break;
            }
            case CONTEXT: {
                path = "trans.context";
                break;
            }
            case TRANSLATION: {
                path = "trans.translatedValue";
                break;
            }
            default: {
                throw new HistoryDataBaseException("Service doesn't support " + String.valueOf((Object)criteria.getField()) + " field");
            }
        }
        if (criteria.getField() == ICriteria.Field.VALUE) {
            if (criteria.getOperator() == ICriteria.CompareOp.LIKE) {
                return "TRUE";
            }
            if (criteria.getOperator() == ICriteria.CompareOp.EQUAL) {
                String val2 = this.escapeSymbols(criteria.getValue().toString().toLowerCase());
                return String.format("LOWER(%s) = '%s'", path, val2);
            }
            String val3 = this.escapeSymbols(StringUtils.nameToText((String)criteria.getValue().toString()).toLowerCase());
            return String.format("LOWER(%s) = '%s'", path, val3);
        }
        String op = switch (criteria.getOperator()) {
            case ICriteria.CompareOp.EQUAL -> "=";
            case ICriteria.CompareOp.LIKE -> "LIKE";
            default -> throw new HistoryDataBaseException("Service doesn't support " + String.valueOf((Object)criteria.getOperator()) + " operation");
        };
        if (criteria.getValue() instanceof Context) {
            Context ctxt = (Context)((Object)criteria.getValue());
            val = String.valueOf(ctxt.ordinal());
        } else {
            val = "'" + String.valueOf(criteria.getValue()) + "'";
        }
        return String.format("%s %s %s", path, op, val);
    }

    public static interface ISqlQuery {
        public String getSelectStatement();

        public String getFromStatement();

        public String getWhereStatement();
    }

    private static final class QueryContext {
        private boolean isLangUsed = false;
        private boolean isProjUsed = false;
        private boolean isStorUsed = false;
        private String translatingValue;

        private QueryContext() {
        }

        public void setLanguageUsed() {
            this.isLangUsed = true;
        }

        public void setProjectUsed() {
            this.isProjUsed = true;
        }

        public void setStorageUsed() {
            this.isStorUsed = true;
        }

        public boolean isProjectUsed() {
            return this.isProjUsed;
        }

        public boolean isStorageUsed() {
            return this.isStorUsed;
        }

        public boolean isLanguageUsed() {
            return this.isLangUsed;
        }

        public void setTranslatingValue(String value) {
            this.translatingValue = value;
        }

        public String getTranslatingValue() {
            return this.translatingValue;
        }
    }

    private static final class SqlQuery
    implements ISqlQuery {
        private final String select;
        private final String from;
        private final String where;

        public SqlQuery(String select, String from, String where) {
            this.select = select;
            this.from = from;
            this.where = where;
        }

        @Override
        public String getSelectStatement() {
            return this.select;
        }

        @Override
        public String getFromStatement() {
            return this.from;
        }

        @Override
        public String getWhereStatement() {
            return this.where;
        }

        public String toString() {
            return String.format("SELECT %s FROM %s WHERE %s;", this.select, this.from, this.where);
        }
    }
}

