/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.tlx.exporter.internal;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.mcore.impl.LocalStringMapEntryImpl;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.core.ext.IBmObjectExporterExtension;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.ls.exporter.LsBmExporter;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.e1c.langtool.v8.dt.tlx.exporter.internal.Messages;
import com.e1c.langtool.v8.dt.tlx.exporter.internal.TlxExporterPlugin;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ConfigurationLanguageExporter
implements IBmObjectExporterExtension {
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    private final LsBmExporter lsBmExporter = LsBmExporter.create();

    public Collection<EClass> targets() {
        return Arrays.asList(MdClassPackage.Literals.CONFIGURATION);
    }

    public void beforeExport(IDtProject dtProject, IBmObject bmObject, IBmObject clone, IFile file, Map<IFile, byte[]> exportedExtraFiles) throws CoreException {
        IProject project = file.getProject();
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (translatingProject.isTranslating() && clone instanceof Configuration) {
            Configuration configuration = (Configuration)clone;
            EList languages = configuration.getLanguages();
            Iterator iterator = languages.iterator();
            List<String> languageCodes = this.getLanguageCodes(translatingProject);
            while (iterator.hasNext()) {
                Language language = (Language)iterator.next();
                Optional optional = LanguageUtil.getTranslateLanguage((ITranslatingProject)translatingProject, (Language)language);
                if (!optional.isPresent()) continue;
                Optional<Language> found = ((Configuration)bmObject).getLanguages().stream().filter(l -> l.getName().equals(language.getName())).findFirst();
                if (found.isPresent()) {
                    this.lsBmExporter.export((IBmObject)found.get(), file, exportedExtraFiles);
                }
                iterator.remove();
                IFile translateLanguageFile = this.getTranslateLanguageFile(translatingProject, language);
                ISchedulingRule rule = Job.getJobManager().currentRule();
                if (rule != null && !rule.contains((ISchedulingRule)translateLanguageFile)) {
                    ResourceSaveJob saveJob = new ResourceSaveJob(Messages.ConfigurationLanguageExporter_Save_Translate_language, translateLanguageFile, languageCodes, language);
                    saveJob.setRule((ISchedulingRule)translateLanguageFile);
                    saveJob.schedule();
                    try {
                        saveJob.join();
                        if (saveJob.getHashCode() == null) continue;
                        exportedExtraFiles.put(translateLanguageFile, saveJob.getHashCode());
                    }
                    catch (InterruptedException e) {
                        TlxExporterPlugin.logError(e);
                    }
                    continue;
                }
                try {
                    exportedExtraFiles.put(translateLanguageFile, this.updateResource(translateLanguageFile, language, languageCodes));
                }
                catch (IOException e) {
                    TlxExporterPlugin.logError(e);
                }
            }
        }
    }

    private List<String> getLanguageCodes(ITranslatingProject project) {
        return project.getInterfaceLanguages().stream().map(TranslateLanguage::getLanguageCode).collect(Collectors.toList());
    }

    private byte[] updateResource(IFile langFile, Language language, List<String> languageCodes) throws IOException {
        V8TranslateLanguage translateLanguage = TranslateLanguageManifest.load((IFile)langFile);
        LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)translateLanguage);
        this.removeTranslations((EObject)translateLanguage, languageCodes);
        return TranslateLanguageManifest.save((IFile)langFile, (V8TranslateLanguage)translateLanguage, (HashFunction)Hashing.sha256(), (IProgressMonitor)new NullProgressMonitor());
    }

    private IFile getTranslateLanguageFile(ITranslatingProject translatingProject, Language language) {
        String languageName = language.getName();
        Optional<TranslateLanguage> optional = translatingProject.getInterfaceLanguages().stream().filter(l -> languageName.equals(l.getName())).findFirst();
        TranslateLanguage translateLanguage = optional.orElse(null);
        IProject external = this.translatingProjectManager.getLanguageProject(translatingProject, translateLanguage);
        IPath path = TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES.append(languageName).append(languageName).addFileExtension("tlx");
        return external.getFile(path);
    }

    private void removeTranslations(EObject object, List<String> languageCodes) {
        ArrayDeque<LocalStringMapEntryImpl> deleteQueue = new ArrayDeque<LocalStringMapEntryImpl>();
        TreeIterator languageContentIterator = object.eAllContents();
        while (languageContentIterator.hasNext()) {
            EObject content = (EObject)languageContentIterator.next();
            if (!(content instanceof LocalStringMapEntryImpl) || !languageCodes.contains(((LocalStringMapEntryImpl)content).getTypedKey())) continue;
            deleteQueue.add((LocalStringMapEntryImpl)content);
        }
        while (!deleteQueue.isEmpty()) {
            LocalStringMapEntryImpl item = (LocalStringMapEntryImpl)deleteQueue.remove();
            item.getEMap().removeKey((Object)item.getTypedKey());
        }
    }

    private final class ResourceSaveJob
    extends Job {
        private final IFile translateLanguageFile;
        private final List<String> languageCodes;
        private final Language language;
        private byte[] hashCode;

        private ResourceSaveJob(String name, IFile translateLanguageFile, List<String> languageCodes, Language language) {
            super(name);
            this.hashCode = null;
            this.translateLanguageFile = translateLanguageFile;
            this.languageCodes = languageCodes;
            this.language = language;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.hashCode = ConfigurationLanguageExporter.this.updateResource(this.translateLanguageFile, this.language, this.languageCodes);
            }
            catch (IOException e) {
                return TlxExporterPlugin.createErrorStatus(MessageFormat.format(Messages.ConfigurationLanguageExporter_Error_while_saving_Translate_languae_in, this.translateLanguageFile.getFullPath()), e);
            }
            return Status.OK_STATUS;
        }

        public byte[] getHashCode() {
            return this.hashCode;
        }
    }
}

