/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.cli.api.impl;

import com._1c.g5.v8.dt.cli.api.IWorkspaceSupport;
import com._1c.g5.v8.dt.common.Builds;
import com._1c.g5.v8.dt.common.FileUtil;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.ProjectUtils;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLanguageProjectApi
implements IImportLanguageProjectApi {
    private static final String ZIP = "zip";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportLanguageProjectApi.class);
    @Inject
    private IWorkspaceSupport workspaceSupport;

    public Collection<IProject> importLanguageProjects(List<java.nio.file.Path> languageProjects) throws TranslationCliApiException {
        Preconditions.checkNotNull(languageProjects);
        return this.importLanguageProjectsInternal(languageProjects);
    }

    public IProject importLanguageProject(java.nio.file.Path languageProject) throws TranslationCliApiException {
        Preconditions.checkNotNull((Object)languageProject);
        Collection<IProject> importedProjects = this.importLanguageProjectsInternal(List.of(languageProject));
        return importedProjects.isEmpty() ? null : importedProjects.iterator().next();
    }

    public Collection<File> findProjectsRecursively(List<java.nio.file.Path> projectPaths) {
        Collection<File> files;
        try {
            files = ProjectUtils.findProjectsRecursively(projectPaths);
        }
        catch (TranslationCliApiException e) {
            LOGGER.error(e.getMessage());
            files = Collections.emptyList();
        }
        return files;
    }

    private Collection<IProject> importLanguageProjectsInternal(List<java.nio.file.Path> languageProjects) {
        java.nio.file.Path location = Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString(), new String[0]);
        Collection<Object> projects = Collections.emptyList();
        try {
            projects = this.handleProjects(languageProjects, location);
        }
        catch (IOException e) {
            throw new TranslationCliApiException((Throwable)e);
        }
        ArrayList<IProject> importedProjects = new ArrayList<IProject>();
        if (projects.isEmpty()) {
            LOGGER.debug("No projects found!");
        } else {
            LOGGER.debug("Projects found: {}", projects);
        }
        for (File file : projects) {
            IProject importedProject = this.importLanguageProject(file);
            importedProjects.add(importedProject);
        }
        return importedProjects;
    }

    private Collection<File> handleProjects(List<java.nio.file.Path> projectPaths, java.nio.file.Path workspace) throws IOException {
        ArrayList<File> projectFiles = new ArrayList<File>();
        for (java.nio.file.Path path : projectPaths) {
            java.nio.file.Path projectFolder;
            if (Files.isRegularFile(path, new LinkOption[0]) && FileUtil.hasExtension((File)path.toFile(), (String)ZIP)) {
                projectFolder = this.getProjectFolder(path, workspace);
                try {
                    this.unzipProject(path, projectFolder);
                }
                catch (IllegalArgumentException e) {
                    String errorMessage = "Error unzipping project: malformed input in ZIP file at offset " + e.getMessage() + ". This might be due to an invalid UTF-8 sequence.";
                    LOGGER.error(errorMessage, (Throwable)e);
                    throw new IOException(errorMessage, e);
                }
            } else {
                Assert.isLegal((boolean)Files.isDirectory(path, new LinkOption[0]));
                projectFolder = path;
            }
            projectFiles.addAll(this.findProjectsRecursively(List.of(projectFolder)));
        }
        return projectFiles;
    }

    private java.nio.file.Path getProjectFolder(java.nio.file.Path zipPath, java.nio.file.Path workspace) throws IOException {
        Assert.isLegal((boolean)FileUtil.hasExtension((File)zipPath.toFile(), (String)ZIP));
        String path = zipPath.getFileName().toString();
        path = path.substring(0, path.length() - 4);
        String folderName = this.findUniqueFolderName(workspace, path);
        return Files.createDirectories(workspace.resolve(folderName), new FileAttribute[0]);
    }

    private String findUniqueFolderName(java.nio.file.Path parentDirectory, String defaultName) {
        java.nio.file.Path newFolderPath = parentDirectory.resolve(defaultName);
        if (!Files.exists(newFolderPath, new LinkOption[0])) {
            return defaultName;
        }
        int suffix = 1;
        String newName;
        while (Files.exists(newFolderPath = parentDirectory.resolve(newName = defaultName + "_" + suffix), new LinkOption[0])) {
            ++suffix;
        }
        return newName;
    }

    private void unzipProject(java.nio.file.Path zipPath, java.nio.file.Path path) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipPath.toFile()));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                java.nio.file.Path entryPath = path.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (OutputStream outputStream = Files.newOutputStream(entryPath, new OpenOption[0]);){
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                zipInputStream.closeEntry();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private IProject importLanguageProject(File projectFile) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IProjectDescription description = workspace.loadProjectDescription((IPath)new Path(projectFile.toString()));
            LOGGER.info("Importing external language project: {}", (Object)description.getName());
            IProject project = this.workspaceSupport.setUpProject(description.getName(), projectFile.getParentFile().toPath());
            ProjectUtils.waitForBuildCompletion(project);
            Builds.scheduleBuild((IProject)project, (boolean)false);
            ProjectUtils.waitForBuildCompletion(project);
            LOGGER.info("External language project: {} build compleated", (Object)project.getName());
            this.workspaceSupport.saveWorkspaseState();
            LOGGER.debug("Workspace state saved");
            return project;
        }
        catch (NullPointerException | CoreException e) {
            throw new TranslationCliApiException(e);
        }
    }
}

