/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.Messages;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectUtils.class);

    public static boolean determineTranslatingProjectSupportedLanguages(ITranslatingProject project, List<String> argsLanguages, List<TranslateLanguage> supportedLanguages, List<String> unsupportedLanguageIds) {
        HashSet uniqLanguages = Sets.newHashSet(argsLanguages);
        HashSet unrecognizedLanguages = Sets.newHashSet(argsLanguages);
        ArrayList languages = Lists.newArrayList((Iterable)project.getInterfaceLanguages());
        TranslateLanguage defaultLanguage = project.getDefaultLanguage();
        if (defaultLanguage != null && !languages.contains(defaultLanguage)) {
            languages.add(defaultLanguage);
        }
        for (TranslateLanguage language : languages) {
            String languageCode = language.getLanguageCode();
            if (uniqLanguages.contains(languageCode)) {
                supportedLanguages.add(language);
                unrecognizedLanguages.remove(languageCode);
                continue;
            }
            String languageName = language.getName();
            if (!uniqLanguages.contains(languageName)) continue;
            supportedLanguages.add(language);
            unrecognizedLanguages.remove(languageName);
        }
        unsupportedLanguageIds.addAll(unrecognizedLanguages);
        return !supportedLanguages.isEmpty();
    }

    public static void waitForBuildCompletion(IProject project) throws CoreException {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                throw new CoreException(CliPlugin.createErrorStatus(MessageFormat.format(Messages.ProjectUtils_Project__0__waiting_for_build_failed, project.getName()), e));
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static boolean isDependentProject(Path location) {
        return location != null && location.toFile().isDirectory() && location.resolve("DT-INF/DEPENDENT.PMF").toFile().exists();
    }

    public static Collection<File> findProjectsRecursively(Collection<Path> projectDirs) {
        HashSet projects = Sets.newHashSet();
        for (Path projectDir : projectDirs) {
            if (!Files.isDirectory(projectDir, new LinkOption[0])) {
                throw new TranslationCliApiException(MessageFormat.format(Messages.ProjectUtils_Provided_location_is_not_existing_directory, projectDir));
            }
            LOGGER.debug("Searching for projects in: {}", (Object)projectDir);
            Set<File> found = ProjectUtils.getProjectsRecursively(projectDir);
            if (found.isEmpty()) {
                LOGGER.warn("External Language project not found in {}", (Object)projectDir);
                continue;
            }
            projects.addAll(found);
        }
        return projects;
    }

    private static Set<File> getProjectsRecursively(Path path) {
        return ProjectUtils.findFilesRecursively(path.toFile(), "\\.project", new HashSet<File>());
    }

    private static Set<File> findFilesRecursively(File root, String pattern, Set<File> returnedList) {
        File[] list = root.listFiles();
        if (list == null) {
            return returnedList;
        }
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                ProjectUtils.findFilesRecursively(f.getAbsoluteFile(), pattern, returnedList);
            } else if (Pattern.matches(pattern, f.getName())) {
                returnedList.add(f);
            }
            ++n2;
        }
        return returnedList;
    }
}

