/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.e1c.langtool.v8.dt.languagecleaner.LanguageCleaner;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class CleanUpLanguageCommand
extends BaseCliCommand {
    private final IConfigurationProvider configurationProvider;
    private final LanguageCleaner languageCleaner;
    private final IDtProjectManager dtProjectManager;

    @Inject
    public CleanUpLanguageCommand(IConfigurationProvider configurationProvider, LanguageCleaner languageCleaner, IDtProjectManager dtProjectManager) {
        this.configurationProvider = configurationProvider;
        this.languageCleaner = languageCleaner;
        this.dtProjectManager = dtProjectManager;
    }

    @CliCommand(command="cleanup-languages", value="CleanupLanguagesCommand_Cleanup_description")
    public IStatus c1_cleanLanguages(@Argument(value={"--project"}, descriptor="CleanupLanguagesCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--clean-languages"}, descriptor="CleanupLanguagesCommand_Param_cleanup_languages_description") String[] languages) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project location: {}", (Object)projectLocation);
            logger.debug("Languages to remove and clean: {}", (Object)String.join((CharSequence)", ", languages));
        }
        try {
            IDtProject dtProject = this.startDtProject(projectLocation.toAbsolutePath());
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages, false);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Configuration_project_not_found__0, projectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            IProject project = dtProject.getWorkspaceProject();
            this.languageCleaner.cleanUpLanguages(project, selectedLanguages, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.CleanupLanguagesCommand_Language_cleanup_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    @CliCommand(command="cleanup-languages", value="CleanupLanguagesCommand_Cleanup_description")
    public IStatus c2_cleanLanguages(@Argument(value={"--project-name"}, descriptor="CleanupLanguagesCommand_Param_project_description") IProject project, @Argument(value={"--clean-languages"}, descriptor="CleanupLanguagesCommand_Param_cleanup_languages_description") String[] languages) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Existing project: {}", (Object)project);
            logger.debug("Languages to remove and clean: {}", (Object)String.join((CharSequence)", ", languages));
        }
        try {
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            IDtProject dtProject = this.dtProjectManager.getDtProject(project);
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages, false);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Configuration_project_not_found__0, project);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            this.languageCleaner.cleanUpLanguages(project, selectedLanguages, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.CleanupLanguagesCommand_Language_cleanup_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    @CliCommand(command="cleanup-languages", value="CleanupLanguagesCommand_Keep_description")
    public IStatus c3_cleanLanguages(@Argument(value={"--project"}, descriptor="CleanupLanguagesCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--keep-languages"}, descriptor="CleanupLanguagesCommand_Param_keep_languages_description") String[] languages) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Project location: {}", (Object)projectLocation);
            logger.debug("Languages to keep: {}", (Object)String.join((CharSequence)", ", languages));
        }
        try {
            IDtProject dtProject = this.startDtProject(projectLocation.toAbsolutePath());
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages, true);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Configuration_project_not_found__0, projectLocation);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            IProject project = dtProject.getWorkspaceProject();
            this.languageCleaner.cleanUpLanguages(project, selectedLanguages, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.CleanupLanguagesCommand_Language_cleanup_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    @CliCommand(command="cleanup-languages", value="CleanupLanguagesCommand_Keep_description")
    public IStatus c4_cleanLanguages(@Argument(value={"--project-name"}, descriptor="CleanupLanguagesCommand_Param_project_description") IProject project, @Argument(value={"--keep-languages"}, descriptor="CleanupLanguagesCommand_Param_keep_languages_description") String[] languages) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Existing project: {}", (Object)project);
            logger.debug("Languages to keep: {}", (Object)String.join((CharSequence)", ", languages));
        }
        try {
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            IDtProject dtProject = this.dtProjectManager.getDtProject(project);
            Set<Language> selectedLanguages = this.getSelectedLanguages(dtProject, languages, true);
            if (selectedLanguages == null) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Configuration_project_not_found__0, project);
                return CliPlugin.createErrorStatus(message, null);
            }
            if (selectedLanguages.isEmpty()) {
                String message = MessageFormat.format(Messages.CleanupLanguagesCommand_Not_selected_any_languges_from_configuration_language_names__0, String.join((CharSequence)", ", languages));
                System.out.println(message);
                return Status.CANCEL_STATUS;
            }
            this.languageCleaner.cleanUpLanguages(project, selectedLanguages, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            return CliPlugin.createErrorStatus(Messages.CleanupLanguagesCommand_Language_cleanup_unsuccessful, e);
        }
        return Status.OK_STATUS;
    }

    private Set<Language> getSelectedLanguages(IDtProject dtProject, String[] languages, boolean keepLanguages) {
        return (Set)this.backgroundOperation("LT-clear-languages-get-languages", dtProject, ProjectPipelineJob.AFTER_BUILD_DD, () -> {
            Configuration configuration = this.configurationProvider.getConfiguration(dtProject);
            if (configuration == null) {
                return null;
            }
            TreeSet<String> languageNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            languageNames.addAll(List.of(languages));
            Language defaultLang = configuration.getDefaultLanguage();
            if (defaultLang != null && !keepLanguages) {
                languageNames.remove(defaultLang.getName());
            }
            return configuration.getLanguages().stream().filter(l -> languageNames.contains(l.getName())).collect(Collectors.toSet());
        });
    }
}

