/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class ImportLanguageProjectCommand
extends BaseCliCommand {
    private final IImportLanguageProjectApi importLanguageProjectApi;

    @Inject
    public ImportLanguageProjectCommand(IImportLanguageProjectApi importLanguageProjectApi) {
        this.importLanguageProjectApi = importLanguageProjectApi;
    }

    @CliCommand(command="import-language-projects", value="ImportLanguageProjectCommand_Description")
    public IStatus importLanguageProjects(@Argument(value={"--language-project-list"}, descriptor="ImportLanguageProjectCommand_Param_language_project_locations_description", elementType=Path.class) Path[] languageProjects) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Language projects: {}", (Object[])languageProjects);
        }
        try {
            this.importLanguageProjectApi.importLanguageProjects(Arrays.asList(languageProjects));
            System.out.println(Messages.ImportLanguageProjectCommand_Language_projects_successfully_imported);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.ImportLanguageProjectCommand_Language_projects_import_failed, e);
        }
    }
}

