/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.cli.api.impl.commands;

import com._1c.g5.v8.dt.core.platform.IDtProject;
import com.e1c.g5.v8.dt.cli.api.Argument;
import com.e1c.g5.v8.dt.cli.api.CliCommand;
import com.e1c.g5.v8.dt.cli.api.components.BaseCliCommand;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.cli.api.IImportLanguageProjectApi;
import com.e1c.langtool.v8.dt.cli.api.ISynchronizeProjectApi;
import com.e1c.langtool.v8.dt.cli.api.TranslationCliApiException;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.CliPlugin;
import com.e1c.langtool.v8.dt.internal.cli.api.impl.commands.Messages;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class SynchronizeProjectCommand
extends BaseCliCommand {
    private static final String DEFAULT_LANGUAGES = "";
    private final ISynchronizeProjectApi synchronizeProjectApi;
    private final IImportLanguageProjectApi importLanguageProjectApi;

    @Inject
    public SynchronizeProjectCommand(ISynchronizeProjectApi synchronizeProjectApi, IImportLanguageProjectApi importLanguageProjectApi) {
        this.synchronizeProjectApi = synchronizeProjectApi;
        this.importLanguageProjectApi = importLanguageProjectApi;
    }

    @CliCommand(command="synchronize", value="SynchronizeProjectCommand_Description")
    public IStatus c1_synchronize(@Argument(value={"--project-name"}, descriptor="SynchronizeProjectCommand_Param_project_name_description") IProject project, @Argument(value={"--languages"}, descriptor="SynchronizeProjectCommand_Param_languages_description", elementType=String.class, defaultValue="") String[] languages, @Argument(value={"--cache-keys"}, defaultValue="", descriptor="SynchronizeProjectCommand_Param_cache_keys_description") boolean cacheKeys) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Languages: {}", (Object)(languages == null ? "null" : languages));
            logger.debug("Existing project: {}", (Object)project);
            logger.debug("Cache keys: {}", (Object)cacheKeys);
        }
        this.waitForDtProjectsStart();
        try {
            this.waitUntilStarted(project, DT_PROJECT_STARTUP_DURATION);
            IDtProject dtProject = this.getContext().getDtProjectManager().getDtProject(project);
            List<String> languageList = this.getLanguageList(languages);
            this.synchronizeProjectApi.synchronizeProject(dtProject, languageList, cacheKeys);
            System.out.println(Messages.SynchronizeProjectCommand_Project_successfully_synchronized);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.SynchronizeProjectCommand_Project_synchronization_failed, e);
        }
    }

    @CliCommand(command="synchronize", value="SynchronizeProjectCommand_Description")
    public IStatus c2_synchronize(@Argument(value={"--project"}, descriptor="SynchronizeProjectCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--languages"}, descriptor="SynchronizeProjectCommand_Param_languages_description", elementType=String.class, defaultValue="") String[] languages, @Argument(value={"--cache-keys"}, defaultValue="", descriptor="SynchronizeProjectCommand_Param_cache_keys_description") boolean cacheKeys) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Languages: {}", (Object)(languages == null ? "null" : languages));
            logger.debug("Project location: {}", (Object)projectLocation);
            logger.debug("Cache keys: {}", (Object)cacheKeys);
        }
        this.waitForDtProjectsStart();
        try {
            IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation));
            List<String> languageList = this.getLanguageList(languages);
            this.synchronizeProjectApi.synchronizeProject(dtProject, languageList, cacheKeys);
            System.out.println(Messages.SynchronizeProjectCommand_Project_successfully_synchronized);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.SynchronizeProjectCommand_Project_synchronization_failed, e);
        }
    }

    @CliCommand(command="synchronize", value="SynchronizeProjectCommand_Description")
    public IStatus c3_synchronize(@Argument(value={"--project"}, descriptor="SynchronizeProjectCommand_Param_project_location_description") Path projectLocation, @Argument(value={"--languages"}, descriptor="SynchronizeProjectCommand_Param_languages_description", elementType=String.class, defaultValue="") String[] languages, @Argument(value={"--language-project-list"}, descriptor="SynchronizeProjectCommand_Param_language_projects_description", elementType=Path.class) Path[] languageProjects, @Argument(value={"--cache-keys"}, defaultValue="", descriptor="SynchronizeProjectCommand_Param_cache_keys_description") boolean cacheKeys) {
        Logger logger = this.getContext().getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug("Language projects: {}", (Object[])languageProjects);
            logger.debug("Languages: {}", (Object)(languages == null ? "null" : languages));
            logger.debug("Project location: {}", (Object)projectLocation);
        }
        this.waitForDtProjectsStart();
        try {
            this.importLanguageProjectApi.importLanguageProjects(Arrays.asList(languageProjects));
            IDtProject dtProject = this.startDtProject(this.getCurrentWorkDir().resolve(projectLocation));
            List<String> languageList = this.getLanguageList(languages);
            this.synchronizeProjectApi.synchronizeProject(dtProject, languageList, cacheKeys);
            System.out.println(Messages.SynchronizeProjectCommand_Project_successfully_synchronized);
            return Status.OK_STATUS;
        }
        catch (TranslationCliApiException e) {
            return CliPlugin.createErrorStatus(Messages.SynchronizeProjectCommand_Project_synchronization_failed, e);
        }
    }

    private List<String> getLanguageList(String[] languages) {
        List<String> languageList;
        List<String> list = languageList = languages == null ? null : Arrays.asList(languages);
        if (languageList != null && languageList.size() == 1 && StringUtils.isBlank((String)languageList.get(0))) {
            languageList = null;
        }
        return languageList;
    }

    private void waitForDtProjectsStart() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject workspaceProject = iProjectArray[n2];
            this.getContext().getWorkspaceOrchestrator().waitUntilStarted(workspaceProject, DT_PROJECT_STARTUP_DURATION);
            ++n2;
        }
    }
}

