/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.google;

import com.e1c.langtool.google.CorePlugin;
import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

public class GoogleQueryBuilder {
    private static final String GRANT_TYPE = "refresh_token";
    private static final String API_URL = "https://translation.googleapis.com/";
    private static final String API_OAUTH_URL = "https://oauth2.googleapis.com/";
    private static final String APPLICATION_JSON = "application/json";
    private static final String API_VERSION = "v3";
    private static final String PATH_PARAMETR_PREFIX_PROJECT = "projects";
    private static final String PATH_PARAMETR_PREFIX_LOCATION = "locations";
    private static final String TRANSLATION_PATH = ":translateText";
    private static final String TOKEN_PATH = "/token";
    private static final String GETTING_LANGS_PATH = "/supportedLanguages";
    private static final String MIME_TYPE = "text/plain";
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(3L);
    private static final String PARAM_DISPLAY_LANGUAGE_CODE = "displayLanguageCode";
    private final Gson gson;
    private final BuilderType builderType;
    private String tokenType;
    protected String tokenText;
    protected String projectID;
    protected String location;
    protected String clientID;
    protected String clientSecret;
    protected String sourceLocale;
    protected String targetLocale;
    protected String model;
    protected List<String> texts = new LinkedList<String>();

    public static GoogleQueryBuilder createTranslationQuery() {
        return new GoogleQueryBuilder(BuilderType.TRANSLATION);
    }

    public static GoogleQueryBuilder createGettingSupportedLanguagesQuery() {
        return new GoogleQueryBuilder(BuilderType.GETTING_SUPPORTED_LANGS);
    }

    public static GoogleQueryBuilder createAccessTokenQuery() {
        return new GoogleQueryBuilder(BuilderType.ACCESS_TOKEN);
    }

    protected GoogleQueryBuilder(BuilderType builderType) {
        this.builderType = builderType;
        this.gson = new Gson();
    }

    public GoogleQueryBuilder token(String token) {
        this.tokenText = token;
        return this;
    }

    public GoogleQueryBuilder tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public GoogleQueryBuilder clientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public GoogleQueryBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public GoogleQueryBuilder projectID(String projectID) {
        this.projectID = projectID;
        return this;
    }

    public GoogleQueryBuilder location(String location) {
        this.location = location;
        return this;
    }

    public GoogleQueryBuilder model(String model) {
        this.model = model;
        return this;
    }

    public GoogleQueryBuilder language(String sourceLocale, String targetLocale) {
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
        return this;
    }

    public GoogleQueryBuilder text(String text) {
        this.texts.add(text);
        return this;
    }

    public HttpRequest build() {
        Request request = new Request();
        URIBuilder uriBuilder = null;
        URI uri = null;
        String path = "v3/projects/" + this.projectID + "/locations/" + this.location;
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", APPLICATION_JSON).timeout(REQUEST_TIMEOUT).version(HttpClient.Version.HTTP_1_1);
        if (this.builderType == BuilderType.ACCESS_TOKEN) {
            uri = URI.create(API_OAUTH_URL);
            uriBuilder = new URIBuilder();
            uriBuilder.setHost(uri.getHost()).setScheme(uri.getScheme());
            uriBuilder.setPath(TOKEN_PATH);
            request.setMimeType(MIME_TYPE);
            request.setClientId(this.clientID);
            request.setClientSecret(this.clientSecret);
            request.setRefreshToken(this.tokenText);
            request.setGrantType(GRANT_TYPE);
            try {
                builder.uri(uriBuilder.build());
            }
            catch (URISyntaxException e) {
                CorePlugin.logError(e);
            }
            String requestBody = this.gson.toJson((Object)request);
            return builder.POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        }
        builder.header("Authorization", this.tokenType + " " + this.tokenText);
        uri = URI.create(API_URL);
        uriBuilder = new URIBuilder();
        uriBuilder.setHost(uri.getHost()).setScheme(uri.getScheme());
        if (this.builderType == BuilderType.TRANSLATION) {
            request.setMimeType(MIME_TYPE);
            request.setSourceLanguageCode(this.sourceLocale);
            request.setTargetLanguageCode(this.targetLocale);
            request.setContents(this.texts);
            uriBuilder.setPath(path + TRANSLATION_PATH);
            try {
                builder.uri(uriBuilder.build());
            }
            catch (URISyntaxException e) {
                CorePlugin.logError(e);
            }
            String requestBody = this.gson.toJson((Object)request);
            return builder.POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        }
        uriBuilder.setPath(path + GETTING_LANGS_PATH);
        uriBuilder.addParameter(PARAM_DISPLAY_LANGUAGE_CODE, "en");
        try {
            builder.uri(uriBuilder.build());
        }
        catch (URISyntaxException e) {
            CorePlugin.logError(e);
        }
        return builder.GET().build();
    }

    public BuilderType getBuilderType() {
        return this.builderType;
    }

    public static enum BuilderType {
        TRANSLATION,
        GETTING_SUPPORTED_LANGS,
        ACCESS_TOKEN;

    }

    public static class GlossaryConfig {
        private GlossaryData glossaryData;

        public GlossaryData getGlossaryData() {
            return this.glossaryData;
        }

        public void setGlossaryData(GlossaryData glossaryData) {
            this.glossaryData = glossaryData;
        }
    }

    public static class GlossaryData {
        private List<LanguageCodePair> languagePair;

        public List<LanguageCodePair> getGlossaryPairs() {
            return this.languagePair;
        }

        public void setGlossaryPairs(List<LanguageCodePair> glossaryPairs) {
            this.languagePair = glossaryPairs;
        }
    }

    public static class LanguageCodePair {
        private String sourceLanguageCode;
        private String targetLanguageCode;

        public String getSourceText() {
            return this.sourceLanguageCode;
        }

        public void setSourceText(String sourceText) {
            this.sourceLanguageCode = sourceText;
        }

        public String getTranslatedText() {
            return this.targetLanguageCode;
        }

        public void setTranslatedText(String translatedText) {
            this.targetLanguageCode = translatedText;
        }
    }

    public static class Request {
        private String sourceLanguageCode;
        private String targetLanguageCode;
        private String mimeType;
        private List<String> contents;
        private String model;
        private GlossaryConfig glossaryConfig;
        private String clientId;
        private String clientSecret;
        private String refreshToken;
        private String grantType;

        public String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        public void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        public void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public List<String> getContents() {
            return this.contents;
        }

        public void setContents(List<String> contents) {
            this.contents = contents;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public GlossaryConfig getGlossaryConfig() {
            return this.glossaryConfig;
        }

        public void setGlossaryConfig(GlossaryConfig glossaryConfig) {
            this.glossaryConfig = glossaryConfig;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public String getGrantType() {
            return this.grantType;
        }

        public void setGrantType(String grantType) {
            this.grantType = grantType;
        }
    }
}

