/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.google;

import com.e1c.langtool.external.ExternalApiAccessLimit;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.InvalidAccessKeyException;
import com.e1c.langtool.external.InvalidLanguagesException;
import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.google.GooglePreferenceConstants;
import com.e1c.langtool.google.GoogleQueryBuilder;
import com.e1c.langtool.google.Messages;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class GoogleTranslateProvider
implements IExternalTranslationProvider {
    public static final String PROVIDER_ID = "com.e1c.langtool.google.googleTranslateProvider";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final String TAG = Messages.GoogleTranslateProvider_ServiceNameTag;
    private static final int CODE_OK = 200;
    private static final int ACCESS_API_PER_MINUTE = 6000;
    private static final int SYMBOLS_PER_MINUTE = 6000000;
    private Preferences preferences = InstanceScope.INSTANCE.getNode("com.e1c.langtool.google");
    protected final HttpClient client = this.createClient();
    private final Gson gson = new Gson();
    private final ExternalApiAccessLimit limits = new ExternalApiAccessLimit(Duration.ofMinutes(1L), 6000, Duration.ofMinutes(1L), 6000000);
    private volatile Set<String> supportedLangs;

    protected HttpClient createClient() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofMillis(5000L)).proxy(ProxySelector.getDefault()).build();
    }

    protected GoogleQueryBuilder createTranslationQuery() {
        return GoogleQueryBuilder.createTranslationQuery();
    }

    private String getRefreshTokenText() {
        return this.preferences.get("refreshToken", GooglePreferenceConstants.DEFAULT_TOKEN);
    }

    private AccessTokenEntity getToken() {
        String projectID = this.getProjectID();
        String clientID = this.getClientID();
        String clientSecret = this.getClientSecret();
        String refToken = this.getRefreshTokenText();
        HttpRequest request = this.createAccessTokenQuery().projectID(projectID).clientID(clientID).clientSecret(clientSecret).token(refToken).build();
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        return (AccessTokenEntity)this.gson.fromJson(response.body(), AccessTokenEntity.class);
    }

    private String getProjectID() {
        return this.preferences.get("projectID", GooglePreferenceConstants.DEFAULT_PROJECT);
    }

    private String getLocation() {
        return this.preferences.get("location", GooglePreferenceConstants.DEFAULT_LOCATION);
    }

    private String getModel() {
        return this.preferences.get("model", GooglePreferenceConstants.DEFAULT_MODEL);
    }

    private String getClientID() {
        return this.preferences.get("clientId", GooglePreferenceConstants.DEFAULT_CLIENT_ID);
    }

    private String getClientSecret() {
        return this.preferences.get("clientSecret", GooglePreferenceConstants.DEFAULT_CLIENT_SECRET);
    }

    public String getTranslationItemImageName() {
        return "icons/obj16/google.png";
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        if (text == null) {
            throw new IllegalArgumentException("The given text must be not null");
        }
        if (text.trim().length() == 0) {
            return Arrays.asList(text);
        }
        AccessTokenEntity tokenAccess = this.getToken();
        String tokenText = "";
        String tokenType = "";
        if (tokenAccess != null) {
            tokenText = tokenAccess.getAccessToken();
            tokenType = tokenAccess.getTokenType();
        }
        String projectID = this.getProjectID();
        String model = this.getModel();
        String location = this.getLocation();
        HttpRequest request = this.createTranslationQuery().projectID(projectID).location(location).token(tokenText).tokenType(tokenType).language(sourceLocale, targetLocale).text(text).model(model).build();
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        TranslateTextResponse translation = (TranslateTextResponse)this.gson.fromJson(response.body(), TranslateTextResponse.class);
        if (translation.getTranslations().isEmpty()) {
            return Arrays.asList("");
        }
        return translation.getTranslations().stream().map(Translation::getText).collect(Collectors.toList());
    }

    private HttpResponse<String> safeExec(HttpRequest request) {
        try {
            this.limits.checkOrWaitAccessApiLimits();
            return this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            throw new ServiceUnavailableException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TranslationServiceException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TranslationServiceException((Throwable)e);
        }
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        AccessTokenEntity tokenAccess = this.getToken();
        String tokenText = tokenAccess.getAccessToken();
        String tokenType = tokenAccess.getTokenType();
        String projectID = this.getProjectID();
        String model = this.getModel();
        String location = this.getLocation();
        GoogleQueryBuilder queryBuilder = this.createTranslationQuery().projectID(projectID).location(location).token(tokenText).tokenType(tokenType).language(sourceLocale, targetLocale).model(model);
        for (String text : texts) {
            if (text == null) {
                throw new IllegalArgumentException("The given text must be not null");
            }
            queryBuilder.text(text);
        }
        HttpRequest request = queryBuilder.build();
        int total = texts.stream().collect(Collectors.summingInt(String::length));
        this.limits.checkOrWaitSymbolLimits(total);
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        TranslateTextResponse entity = (TranslateTextResponse)this.gson.fromJson(response.body(), TranslateTextResponse.class);
        return this.toResultTranslationMap(texts, entity);
    }

    private Map<String, List<String>> toResultTranslationMap(List<String> texts, TranslateTextResponse entity) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        Iterator<Translation> resIt = entity.getTranslations().iterator();
        for (String text : texts) {
            res.put(text, Arrays.asList(resIt.next().getText()));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLanguageCodes() {
        Set<String> result = this.supportedLangs;
        if (result == null) {
            GoogleTranslateProvider googleTranslateProvider = this;
            synchronized (googleTranslateProvider) {
                result = this.supportedLangs;
                if (result == null) {
                    this.supportedLangs = result = Collections.unmodifiableSet(this.getSupportedLanguages().keySet());
                }
            }
        }
        return result;
    }

    protected GoogleQueryBuilder createGettingSupportedLanguagesQuery() {
        return GoogleQueryBuilder.createGettingSupportedLanguagesQuery();
    }

    protected GoogleQueryBuilder createAccessTokenQuery() {
        return GoogleQueryBuilder.createAccessTokenQuery();
    }

    private Map<String, String> getSupportedLanguages() {
        AccessTokenEntity tokenAccess = this.getToken();
        String tokenText = tokenAccess.getAccessToken();
        String tokenType = tokenAccess.getTokenType();
        String projectID = this.getProjectID();
        String location = this.getLocation();
        HttpRequest request = this.createGettingSupportedLanguagesQuery().projectID(projectID).location(location).token(tokenText).tokenType(tokenType).build();
        HttpResponse<String> response = this.safeExec(request);
        this.handleResponse(response);
        SupportedLanguages entity = (SupportedLanguages)this.gson.fromJson(response.body(), SupportedLanguages.class);
        TreeMap<String, String> languages = new TreeMap<String, String>();
        if (entity.getLanguages() != null) {
            for (SupportedLanguage lang : entity.getLanguages()) {
                languages.put(String.valueOf(lang.getLanguageCode()), lang.getDisplayName());
            }
        }
        return languages;
    }

    private void handleResponse(HttpResponse<String> response) {
        if (response.statusCode() == 501) {
            throw new InvalidLanguagesException(this.getExceptionMsg(Messages.GoogleTranslateProvider_501ErrorMsg, 501));
        }
        if (response.statusCode() == 400) {
            throw new InvalidAccessKeyException(this.getExceptionMsg(Messages.GoogleTranslateProvider_400ErrorMsg, 400));
        }
        if (response.statusCode() == 401) {
            throw new InvalidAccessKeyException(this.getExceptionMsg(Messages.GoogleTranslateProvider_401ErrorMsg, 401));
        }
        if (response.statusCode() == 404) {
            throw new InvalidAccessKeyException(this.getExceptionMsg(Messages.GoogleTranslateProvider_404ErrorMsg, 404));
        }
        if (response.statusCode() != 200) {
            throw new TranslationServiceException(this.getExceptionMsg(Messages.GoogleTranslateProvider_UnknowErrorMsg, response.statusCode()));
        }
    }

    private String getExceptionMsg(String msg, int code) {
        return String.format("%s %s (%d)", TAG, msg, code);
    }

    public Map<String, String> getLanguages(String targetLocale) {
        return this.getSupportedLanguages();
    }

    public static class AccessTokenEntity {
        private String access_token;
        private String expires_in;
        private String scope;
        private String token_type;

        public String getAccessToken() {
            return this.access_token;
        }

        public void setAccessToken(String accessToken) {
            this.access_token = accessToken;
        }

        public String getExpiresIn() {
            return this.expires_in;
        }

        public void setExpiresIn(String expiresIn) {
            this.expires_in = expiresIn;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getTokenType() {
            return this.token_type;
        }

        public void setTokenType(String tokenType) {
            this.token_type = tokenType;
        }
    }

    public static class SupportedLanguage {
        private String languageCode;
        private Boolean supportSource;
        private Boolean supportTarget;
        private String displayName;

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public Boolean getSupportSource() {
            return this.supportSource;
        }

        public void setSupportSource(Boolean supportSource) {
            this.supportSource = supportSource;
        }

        public Boolean getSupportTarget() {
            return this.supportTarget;
        }

        public void setSupportTarget(Boolean supportTarget) {
            this.supportTarget = supportTarget;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class SupportedLanguages {
        private List<SupportedLanguage> languages;

        public List<SupportedLanguage> getLanguages() {
            return this.languages;
        }

        public void setLanguages(List<SupportedLanguage> languages) {
            this.languages = languages;
        }
    }

    public static class TranslateTextGlossaryConfig {
        private String glossary;
        private Boolean ignoreCase;

        public String getGlossary() {
            return this.glossary;
        }

        public void setGlossary(String glossary) {
            this.glossary = glossary;
        }

        public Boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(Boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }
    }

    public static class TranslateTextResponse {
        private List<Translation> translations;
        private List<Translation> glossaryTranslations;

        public List<Translation> getTranslations() {
            return this.translations;
        }

        public void setTranslations(List<Translation> translations) {
            this.translations = translations;
        }

        public List<Translation> getGlossaryTranslations() {
            return this.glossaryTranslations;
        }

        public void setGlossaryTranslations(List<Translation> glossaryTranslations) {
            this.glossaryTranslations = glossaryTranslations;
        }
    }

    public static class Translation {
        private String translatedText;
        private String model;
        private String detectedLanguageCode;
        private List<TranslateTextGlossaryConfig> glossaryConfig;

        public String getText() {
            return this.translatedText;
        }

        public void setText(String text) {
            this.translatedText = text;
        }

        public String getDetectedLanguageCode() {
            return this.detectedLanguageCode;
        }

        public void setDetectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public List<TranslateTextGlossaryConfig> getGlossaryConfig() {
            return this.glossaryConfig;
        }

        public void setGlossaryConfig(List<TranslateTextGlossaryConfig> glossaryConfig) {
            this.glossaryConfig = glossaryConfig;
        }
    }
}

