/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md.help;

import com._1c.g5.v8.bm.core.IBmEngine;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.dt.core.filesystem.IQualifiedNameFilePathConverter;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.mcore.Help;
import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.md.help.MdHelpUtil;
import com._1c.g5.v8.dt.metadata.mdclass.BasicForm;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.core.ext.IResourceContentImporterExtension;
import com.e1c.langtool.v8.dt.internal.md.help.AbstractHelpPageExtension;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class HelpPageImporterExtension
extends AbstractHelpPageExtension
implements IResourceContentImporterExtension {
    private static final String HELP_PATH = "Help";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IQualifiedNameFilePathConverter filePathConverter;

    public Collection<EClass> targets() {
        return TOP_HELP_HOLDERS;
    }

    public void afterImport(IBmEngine engine, IBmTransaction transaction, Resource resource, IPath path, IBmObject importedObject) {
        IProject project = this.resourceLookup.getProject((EObject)importedObject);
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating()) {
            return;
        }
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            IProject sourceProject = this.translatingProjectManager.getLanguageProject(translating, language);
            if (sourceProject == null) continue;
            this.importContent(transaction, (EObject)importedObject, language, project);
        }
    }

    private void importContent(IBmTransaction transaction, EObject importedObject, TranslateLanguage language, IProject sourceProject) {
        Help help;
        QualifiedName fqn = this.nameProvider.getFullyQualifiedName(importedObject);
        QualifiedName helpFqn = fqn.append(HELP_PATH).append(language.getLanguageCode());
        IPath iPath = this.filePathConverter.getFilePath(helpFqn, McorePackage.Literals.HELP);
        IFile pageFile = sourceProject.getFile(iPath);
        if (pageFile.exists() && (help = MdHelpUtil.getHelp((EObject)importedObject)) != null) {
            MdHelpUtil.getHelpPage((Help)help, (String)language.getLanguageCode(), (IBmTransaction)transaction);
        }
        this.getForms(importedObject).forEach(f -> this.importContent(transaction, (EObject)f, language, sourceProject));
    }

    private List<BasicForm> getForms(EObject eObject) {
        ArrayList<BasicForm> allForms = new ArrayList<BasicForm>();
        EStructuralFeature formFetaure = this.getFormsFeature(eObject);
        if (formFetaure != null) {
            List forms = (List)eObject.eGet(formFetaure);
            allForms.addAll(forms);
        }
        return allForms;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EStructuralFeature getFormsFeature(EObject eObject) {
        void reference;
        EClass eClass = eObject.eClass();
        EStructuralFeature feature = eClass.getEStructuralFeature("forms");
        if (feature == null) return null;
        if (!feature.isMany()) return null;
        EStructuralFeature eStructuralFeature = feature;
        if (!(eStructuralFeature instanceof EReference)) return null;
        EReference eReference = (EReference)eStructuralFeature;
        EReference cfr_ignored_0 = (EReference)eStructuralFeature;
        if (!MdClassPackage.Literals.BASIC_FORM.isSuperTypeOf(reference.getEReferenceType())) return null;
        if (!reference.isContainment()) return null;
        boolean bl = true;
        boolean isFormsFetaure = bl;
        if (!isFormsFetaure) return null;
        EStructuralFeature eStructuralFeature2 = feature;
        return eStructuralFeature2;
    }
}

