/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.md.help;

import com._1c.g5.wiring.InjectorAwareServiceRegistrator;
import com._1c.g5.wiring.ServiceInitialization;
import com.e1c.langtool.v8.dt.internal.md.help.ExternalDependenciesModule;
import com.e1c.langtool.v8.dt.internal.md.help.HelpPageProjectFileSystemSupportExtension;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class HelpPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.e1c.langtool.v8.dt.md.help";
    private static HelpPlugin plugin;
    private volatile Injector injector;
    private InjectorAwareServiceRegistrator registrator;
    private static BundleContext context;

    public static HelpPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logError(Throwable throwable) {
        HelpPlugin.log(HelpPlugin.createErrorStatus(throwable.getMessage(), throwable));
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return new Status(4, PLUGIN_ID, 0, message, throwable);
    }

    public static IStatus createWarningStatus(String message) {
        return new Status(2, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createWarningStatus(String message, Exception throwable) {
        return new Status(2, PLUGIN_ID, 0, message, (Throwable)throwable);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        this.registrator = new InjectorAwareServiceRegistrator(context, this::getInjector);
        ServiceInitialization.schedule(() -> {
            try {
                this.registrator.service(HelpPageProjectFileSystemSupportExtension.class).registerInjected();
            }
            catch (Exception e) {
                HelpPlugin.logError(e);
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registrator.unregisterServices();
        this.injector = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Injector getInjector() {
        Injector localInstance = this.injector;
        if (localInstance != null) return localInstance;
        Class<HelpPlugin> clazz = HelpPlugin.class;
        synchronized (HelpPlugin.class) {
            localInstance = this.injector;
            if (localInstance != null) return localInstance;
            this.injector = localInstance = this.createInjector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localInstance;
        }
    }

    private Injector createInjector() {
        try {
            return Guice.createInjector((Module[])new Module[]{new ExternalDependenciesModule(this)});
        }
        catch (Exception e) {
            HelpPlugin.log(HelpPlugin.createErrorStatus("Failed to create injector for " + this.getBundle().getSymbolicName(), e));
            throw new RuntimeException("Failed to create injector for " + this.getBundle().getSymbolicName(), e);
        }
    }

    public IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return preferences;
    }
}

