/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.md.help.sync;

import com._1c.g5.v8.bm.core.BmUriUtil;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.internal.md.help.HelpPlugin;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.sync.ReplacebleExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

public class HelpPicturesSynchronizer
extends ReplacebleExternalPropertySynchronizer {
    private static final String ID = "com.e1c.langtool.v8.dt.md.help.HelpPictures";
    private static final String HELP_SEGMENT = "Help";
    private static final String SEGMENT_FILES = "_files";
    @Inject
    protected IBmModelManager modelManager;

    public String getId() {
        return ID;
    }

    public Collection<IResource> synchronize(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        IProject project = sourceFile.getProject();
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (!this.checkFile(sourceFile)) {
            if (HelpPlugin.getDefault().isDebugging()) {
                System.out.println("File is not pic of MD Help. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return result;
        }
        if (!sourceFile.isAccessible() || !(session instanceof BmSyncSession) || monitor.isCanceled()) {
            return result;
        }
        BmSyncSession bmSession = (BmSyncSession)session;
        IPath sourcePath = sourceFile.getProjectRelativePath();
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(sourcePath);
        fqn = this.qualifiedNameFilePathConverter.getFqn(sourcePath);
        if (fqn == null || fqn.isEmpty()) {
            if (HelpPlugin.getDefault().isDebugging()) {
                System.out.println("FQN is empty. Cannot provide EMF Object from file: " + sourceFile.getFullPath().toString());
            }
            return null;
        }
        IBmModel model = this.modelManager.getModel(project);
        if (model == null) {
            return result;
        }
        boolean newTransaction = false;
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(false);
            newTransaction = true;
        }
        try {
            IPath path = sourcePath.removeFirstSegments(1);
            URI uri = path.segmentCount() > 2 && "Forms".equals(path.segment(2)) ? this.generateFormFqnString(sourceFile.getProject(), sourceFile) : this.generateMdFqnString(sourceFile.getProject(), sourceFile);
            IBmObject owner = transaction.getObjectByUri(uri);
            if (owner == null) {
                if (HelpPlugin.getDefault().isDebugging()) {
                    System.out.println("Owner not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IProjectTranslationProvider translationProvider = bmSession.getTranslationProvider();
            String translatedFqn = this.topObjectFqnGenerator.generateFqn((EObject)owner, translationProvider);
            String filePath = null;
            if (translatedFqn != null) {
                QualifiedName newFqn = this.qualifiedNameConverter.toQualifiedName(translatedFqn);
                newFqn = newFqn.append(HELP_SEGMENT);
                filePath = this.qualifiedNameFilePathConverter.getFilePath(newFqn);
            }
            if (filePath == null) {
                if (HelpPlugin.getDefault().isDebugging()) {
                    System.out.println("Target file path is empty. Cannot synchronize file: " + sourceFile.getFullPath().toString());
                }
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            Path targetPath = new Path(filePath);
            if ((targetPath = targetPath.append(SEGMENT_FILES).append(sourcePath.lastSegment())).segmentCount() != sourceFile.getProjectRelativePath().segmentCount()) {
                String message = MessageFormat.format("MD Help picture synchronization failed.\nSource file: {0}\npath in target project: {1}", sourceFile.getFullPath(), targetPath);
                HelpPlugin.log(HelpPlugin.createErrorStatus(message, null));
                LinkedHashSet linkedHashSet = result;
                return linkedHashSet;
            }
            IFile targetFile = target.getProject().getFile((IPath)targetPath);
            IStatus status = this.synchronize(sourceFile, (EObject)owner, target.getProject(), targetFile, bmSession, translationProvider, monitor);
            if (status.isOK()) {
                result.add(targetFile);
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newTransaction) {
                transaction.rollback();
            }
        }
    }

    private boolean checkFile(IFile sourceFile) {
        IPath path = sourceFile.getProjectRelativePath();
        String[] seg = path.segments();
        int l = seg.length;
        return l > 3 && "src".equals(seg[0]) && HELP_SEGMENT.equals(seg[l - 3]) && SEGMENT_FILES.equals(seg[l - 2]);
    }

    private URI generateFormFqnString(IProject project, IFile file) {
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(file);
        return BmUriUtil.createContainedBmObjectUri((String)file.getProject().getName(), (String)fqn.skipLast(5).toString(), (String)("/forms:" + file.getProjectRelativePath().segment(4)));
    }

    private URI generateMdFqnString(IProject project, IFile file) {
        QualifiedName fqn = this.qualifiedNameFilePathConverter.getFqn(file);
        return BmUriUtil.createTopBmObjectUri((String)file.getProject().getName(), (String)fqn.skipLast(3).toString());
    }
}

