/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.right.templates;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.right.templates.model.RootTemplate;
import com._1c.g5.v8.dt.right.templates.model.StringLiteral;
import com._1c.g5.v8.dt.right.templates.model.TextStatement;
import com._1c.g5.v8.dt.right.templates.model.ValueLiteral;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.internal.right.templates.CorePlugin;
import com.e1c.langtool.v8.dt.ql.QlUtil;
import com.e1c.langtool.v8.dt.right.templates.RightTemplateProcessor;
import com.e1c.langtool.v8.dt.right.templates.RightTemplatesUtil;
import com.e1c.langtool.v8.dt.right.templates.settings.RightTemplateFeatureSettings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class RightTemplateFeaturesCollector
extends RightTemplateProcessor
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IDependentModelProvider dependentModelProvider;
    private final Set<Integer> processedNode = ConcurrentHashMap.newKeySet();
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private IFile resourceFile;

    public static RightTemplateFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        RightTemplateFeaturesCollector collector = new RightTemplateFeaturesCollector(object, parameters, addAction);
        CorePlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public RightTemplateFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        if (object == null) {
            return;
        }
        if (clazz.equals(TextStatement.class) && StringUtils.isNotWord((String)((TextStatement)object).getContent()) || clazz.equals(StringLiteral.class) && StringUtils.isNotWord((String)((StringLiteral)object).getContent()) || clazz.equals(ValueLiteral.class) && StringUtils.isNotWord((String)((ValueLiteral)object).getValue())) {
            return;
        }
        FeaturesCollectorUtil.collectFeatures(object, (CollectingContext)this.getContext(), (IProgressMonitor)this.monitor);
        if (object instanceof StringLiteral) {
            this.doProcess((StringLiteral)object);
        }
        if (object instanceof RootTemplate) {
            QlUtil.collectComments(object, (CollectingContext)this.getContext(), this.processedNode, (IProgressMonitor)this.monitor);
        }
    }

    private void doProcess(StringLiteral literal) {
        boolean hasValue;
        if (!this.context.getParameters().isCollectModelStrings()) {
            return;
        }
        String literalContent = RightTemplatesUtil.getString(literal).trim();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)RightTemplateFeatureSettings.Literals.STRING_LITERAL__CONTENT);
        boolean isComputedValue = false;
        if (StringUtils.isNotEmpty((String)literalContent)) {
            isComputedValue = this.isComputedValue(literal, literalContent, this.context);
        }
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, (FeatureSettings)RightTemplateFeatureSettings.Literals.STRING_LITERAL__CONTENT, literalContent, isComputedValue);
        HashMap nls = Maps.newHashMap();
        if (StringUtils.isNotEmpty((String)literalContent)) {
            nls.put(this.context.getDefaultLanguageCode(), literalContent);
        }
        FeaturesCollectorUtil.fillLocalStrings((Map)featureValue.getLocalStrings(), (Map)nls, (Collection)this.context.getParameters().getLanguages());
        boolean bl = hasValue = StringUtils.isNotEmpty((String)literalContent) || !featureValue.getLocalStrings().isEmpty();
        if (!this.context.getParameters().isCollectEmptyValue() && !hasValue) {
            return;
        }
        if (TranslationUtils.isValidValueForCollectModelType((boolean)isComputedValue, (boolean)false, (boolean)false, (ICollectingParameters.CollectModelType)this.context.getParameters().getCollectModelType())) {
            this.context.getAddAction().accept(literal, featureValue);
        }
    }

    protected boolean isComputedValue(StringLiteral literal, String content, CollectingContext context) {
        return context.getComputedNameService().isComputedString((EObject)literal, RightTemplateFeatureSettings.Literals.STRING_LITERAL__CONTENT);
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(this.object), this.addAction, this.getResourceFile());
        }
        return this.context;
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            EObject root = this.object;
            while (root != null && root.eResource() != null && !root.eResource().getContents().isEmpty()) {
                EObject parent = this.dependentModelProvider.getParent(root = (EObject)root.eResource().getContents().get(0));
                if (parent == null) break;
                root = parent;
            }
            this.resourceFile = this.resourceLookup.getPlatformResource(root);
        }
        return this.resourceFile;
    }
}

