/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.builder;

import com.e1c.langtool.builder.ITranslationBuilderParticipant;
import com.e1c.langtool.internal.builder.plugin.BuilderPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BuilderParticipantRegistry {
    public static final String EXTENSION_POINT_ID = "com.e1c.langtool.builder.participant";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private volatile Map<String, ParticipantAttrs> participantAttrs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ParticipantAttrs> getParticipantAttrs() {
        if (this.participantAttrs == null) {
            BuilderParticipantRegistry builderParticipantRegistry = this;
            synchronized (builderParticipantRegistry) {
                if (this.participantAttrs == null) {
                    this.participantAttrs = this.loadAttrs();
                }
            }
        }
        return this.participantAttrs;
    }

    public ITranslationBuilderParticipant getParticipantById(String id) {
        ParticipantAttrs attr = this.getParticipantAttrs().get(id);
        return attr == null ? null : attr.getParticipant();
    }

    public List<ITranslationBuilderParticipant> getAllParticipants() {
        this.getParticipantAttrs();
        ArrayList<ITranslationBuilderParticipant> participants = new ArrayList<ITranslationBuilderParticipant>();
        this.participantAttrs.values().forEach(attr -> {
            boolean bl = participants.add(attr.participant);
        });
        return participants;
    }

    private Map<String, ParticipantAttrs> loadAttrs() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        HashMap<String, ParticipantAttrs> attrs = new HashMap<String, ParticipantAttrs>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                ParticipantAttrs attr = this.loadParticipantAttrs(configurationElement);
                attrs.put(attr.getId(), attr);
            }
            catch (CoreException e) {
                BuilderPlugin.logError(e);
            }
            ++n2;
        }
        return attrs;
    }

    private ParticipantAttrs loadParticipantAttrs(IConfigurationElement configurationElement) throws CoreException {
        String id = configurationElement.getAttribute(ATTR_ID);
        String name = configurationElement.getAttribute(ATTR_NAME);
        ITranslationBuilderParticipant participant = (ITranslationBuilderParticipant)configurationElement.createExecutableExtension(ATTR_CLASS);
        return new ParticipantAttrs(id, name, participant);
    }

    public static final class ParticipantAttrs {
        private final String id;
        private final String name;
        private final ITranslationBuilderParticipant participant;

        public ParticipantAttrs(String id, String name, ITranslationBuilderParticipant participant) {
            this.id = id;
            this.name = name;
            this.participant = participant;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ITranslationBuilderParticipant getParticipant() {
            return this.participant;
        }
    }
}

