/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.builder;

import com._1c.g5.wiring.IManagedService;
import com.e1c.langtool.builder.ActionType;
import com.e1c.langtool.builder.BuiltResource;
import com.e1c.langtool.builder.IBuiltResourceQueue;
import com.e1c.langtool.builder.QueueChangeEvent;
import com.e1c.langtool.internal.builder.BuiltResourceStorage;
import com.e1c.langtool.internal.builder.IBuiltResourceStorage;
import com.e1c.langtool.internal.builder.InvokeParticipantService;
import com.e1c.langtool.internal.builder.Messages;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

@Singleton
public class BuiltResourceQueue
implements IBuiltResourceQueue,
IManagedService {
    private final Map<String, IBuiltResourceStorage> storages;
    private volatile boolean muteState = false;
    private final ListenerList<IBuiltResourceQueue.IQueueChangeListener> listeners = new ListenerList();
    @Inject
    private Provider<InvokeParticipantService> participantServiceProvider;
    private volatile InvokeParticipantService participantService;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final Map<String, IProject> projects = new HashMap<String, IProject>();

    public BuiltResourceQueue() {
        this.storages = new HashMap<String, IBuiltResourceStorage>();
    }

    @Override
    public synchronized void add(IProject project, BuiltResource resource) {
        this.putResource(project, resource);
        if (!this.muteState) {
            QueueChangeEvent event = new QueueChangeEvent(resource.getPath(), resource.getType(), project.getName());
            this.fireChangedActions(event);
        }
    }

    @Override
    public Job asyncInvokeParticipants(IProject project, Runnable callback) {
        Job job = this.createJob(project, callback);
        this.executorService.submit(() -> job.schedule());
        return job;
    }

    @Override
    public void syncInvokeParticipants(IProject project, IProgressMonitor monitor) {
        this.safeInvokeParticipants(project, monitor);
    }

    @Override
    public Collection<IProject> getBuiltProjects() {
        return this.projects.values();
    }

    @Override
    public void addQueuePostChangeListener(IBuiltResourceQueue.IQueueChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeQueuePostChangeListener(IBuiltResourceQueue.IQueueChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public synchronized void mute() {
        this.muteState = true;
    }

    @Override
    public synchronized void unmute() {
        this.muteState = false;
        this.storages.values().forEach(IBuiltResourceStorage::commit);
    }

    @Override
    public synchronized void unmute(QueueChangeEvent event) {
        this.muteState = false;
        this.storages.values().forEach(IBuiltResourceStorage::commit);
        this.fireChangedActions(event);
    }

    @Override
    public boolean isMute() {
        return this.muteState;
    }

    public void activate() {
    }

    public void deactivate() {
        this.executorService.shutdown();
        if (this.participantService != null) {
            this.participantService.shutdown();
        }
    }

    private static void runSafeAsync(Runnable runnable) {
        CompletableFuture.runAsync(() -> SafeRunner.run(runnable::run));
    }

    private Job createJob(final IProject project, final Runnable callback) {
        Job job = new Job(Messages.BuiltResourceQueue_IndexingTranslationsFor + project.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.BuiltResourceQueue_InvokingParticipantsTaskName, 1);
                BuiltResourceQueue.this.safeInvokeParticipants(project, monitor);
                BuiltResourceQueue.runSafeAsync(callback);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        return job;
    }

    private void safeInvokeParticipants(IProject project, IProgressMonitor progressMonitor) {
        Lock lockByProject = this.locks.computeIfAbsent(project.getName(), key -> new ReentrantLock());
        lockByProject.lock();
        try {
            this.invokeParticipants(project, progressMonitor);
        }
        finally {
            lockByProject.unlock();
        }
    }

    private void invokeParticipants(IProject project, IProgressMonitor progressMonitor) {
        IBuiltResourceStorage storage = this.storages.get(project.getName());
        if (storage == null) {
            return;
        }
        boolean cleaned = this.getParticipantService().process(storage, progressMonitor);
        if (cleaned) {
            storage.deactivate();
            this.storages.remove(project.getName());
            this.projects.remove(project.getName());
        }
    }

    private void putResource(IProject project, BuiltResource resource) {
        IBuiltResourceStorage storage = this.storages.computeIfAbsent(project.getName(), key -> {
            BuiltResourceStorage stor = new BuiltResourceStorage(project);
            stor.activate();
            this.projects.put(project.getName(), project);
            return stor;
        });
        if (resource.getType() == ActionType.CLEANED) {
            storage.clear();
            storage.setDefaultCleanAction();
        } else {
            storage.add(resource);
        }
        if (!this.muteState) {
            storage.commit();
        }
    }

    private void fireChangedActions(QueueChangeEvent event) {
        this.listeners.forEach(listener -> BuiltResourceQueue.runSafeAsync(() -> listener.changed(event)));
    }

    private synchronized InvokeParticipantService getParticipantService() {
        if (this.participantService == null) {
            this.participantService = (InvokeParticipantService)this.participantServiceProvider.get();
        }
        return this.participantService;
    }
}

