/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.builder;

import com.e1c.langtool.builder.ActionType;
import com.e1c.langtool.builder.BuiltResource;
import com.e1c.langtool.internal.builder.IBuiltResourceStorage;
import com.e1c.langtool.internal.builder.plugin.BuilderPlugin;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.osgi.framework.Bundle;

public class BuiltResourceStorage
implements IBuiltResourceStorage {
    private static final BuiltResource EMPTY_BUILT_RESOURCE = new BuiltResource("", ActionType.ADDED);
    private static final String DB_FILE_NAME = "built_resources.db";
    private static final String SET_NAME = "buit_resources";
    private static final String CLEAN_ACTION_NAME = "cleanAction";
    private static final int CACHE_SIZE = 300;
    private final IProject project;
    private DB db;
    private Set<BuiltResource> set;
    private Atomic.Var<BuiltResource> cleanAction;

    public BuiltResourceStorage(IProject project) {
        this.project = project;
    }

    @Override
    public void activate() {
        if (this.db == null || this.db.isClosed()) {
            Thread.currentThread().setContextClassLoader(ResourceSerializer.class.getClassLoader());
            File file = this.getStorageFile();
            this.db = DBMaker.newFileDB((File)file).closeOnJvmShutdown().transactionDisable().cacheLRUEnable().cacheSize(300).make();
            this.set = this.db.createHashSet(SET_NAME).serializer((Serializer)new ResourceSerializer()).makeOrGet();
            this.cleanAction = (Atomic.Var)this.db.get(CLEAN_ACTION_NAME);
            if (this.cleanAction == null) {
                this.cleanAction = this.db.createAtomicVar(CLEAN_ACTION_NAME, (Object)EMPTY_BUILT_RESOURCE, (Serializer)new ResourceSerializer());
            }
        }
    }

    @Override
    public synchronized void deactivate() {
        if (this.db != null && !this.db.isClosed()) {
            this.db.close();
        }
        this.db = null;
        this.set = null;
        this.cleanAction = null;
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public boolean isActivated() {
        return this.db != null && !this.db.isClosed() && this.set != null && this.cleanAction != null;
    }

    @Override
    public int size() {
        this.checkActivated();
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkActivated();
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.checkActivated();
        return this.set.contains(o);
    }

    @Override
    public Iterator<BuiltResource> iterator() {
        this.checkActivated();
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        this.checkActivated();
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.checkActivated();
        return this.set.toArray(a);
    }

    @Override
    public boolean add(BuiltResource e) {
        this.checkActivated();
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.checkActivated();
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkActivated();
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends BuiltResource> c) {
        this.checkActivated();
        return this.set.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkActivated();
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkActivated();
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.checkActivated();
        this.set.clear();
    }

    @Override
    public Optional<BuiltResource> getCleanAction() {
        this.checkActivated();
        BuiltResource resource = (BuiltResource)this.cleanAction.get();
        if (resource == EMPTY_BUILT_RESOURCE) {
            return Optional.empty();
        }
        return Optional.ofNullable(resource);
    }

    @Override
    public void setDefaultCleanAction() {
        this.checkActivated();
        this.cleanAction.set((Object)new BuiltResource(this.project.getFullPath().toString(), ActionType.CLEANED));
    }

    @Override
    public void setCleanAction(BuiltResource resource) {
        this.checkActivated();
        if (resource != null && resource.getType() == ActionType.CLEANED) {
            throw new IllegalArgumentException("The given built resource has invalid action type.");
        }
        this.cleanAction.set((Object)resource);
    }

    @Override
    public void removeCleanAction() {
        this.checkActivated();
        this.cleanAction.set((Object)EMPTY_BUILT_RESOURCE);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuiltResourceStorage other = (BuiltResourceStorage)obj;
        return !(this.set == null ? other.set != null : !this.set.equals(other.set));
    }

    private void checkActivated() {
        if (this.db == null || this.db.isClosed() || this.set == null) {
            throw new IllegalStateException("Storage is not activated before access");
        }
    }

    private File getStorageFile() {
        IPath path = Platform.getStateLocation((Bundle)BuilderPlugin.getDefault().getBundle());
        IPath folder = path.append(this.project.getName());
        folder.toFile().mkdirs();
        return folder.append(DB_FILE_NAME).toFile();
    }

    private static final class ResourceSerializer
    implements Serializer<BuiltResource>,
    Serializable {
        private static final long serialVersionUID = 5893912419583686008L;

        private ResourceSerializer() {
        }

        public BuiltResource deserialize(DataInput in, int res) throws IOException {
            if (res == 0) {
                return null;
            }
            String path = in.readUTF();
            int actionTypeOrdinal = in.readInt();
            ActionType type = ActionType.values()[actionTypeOrdinal];
            return new BuiltResource(path, type);
        }

        public int fixedSize() {
            return 0;
        }

        public void serialize(DataOutput out, BuiltResource res) throws IOException {
            if (res != null) {
                out.writeUTF(res.getPath());
                out.writeInt(res.getType().ordinal());
            }
        }
    }
}

