/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.moxel;

import com.e1c.langtool.common.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MoxelUtils {
    private static final Pattern PARAMETER1_PATTERN = Pattern.compile("\\[\\b([A-Za-z\u0410-\u044f\u0401\u0451_]+[a-zA-Z\u0410-\u044f\u0401\u04510-9_\\.]+)\\b\\]", 256);

    public static Map<String, String> getParamsMapFromNls(String nlsString) {
        if (StringUtils.isNullOrEmpty((String)nlsString)) {
            return Maps.newHashMap();
        }
        Matcher m = PARAMETER1_PATTERN.matcher(nlsString);
        HashMap params = Maps.newHashMap();
        while (m.find()) {
            String source = m.group(0);
            String param = m.group(1);
            if (!StringUtils.isNotEmpty((String)param)) continue;
            params.put(param, source);
        }
        return params;
    }

    private MoxelUtils() {
        throw new IllegalAccessError("Utility class");
    }
}

