/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.moxel.sync;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.moxel.LanguageInfo;
import com._1c.g5.v8.dt.moxel.MoxelFactory;
import com._1c.g5.v8.dt.moxel.SpreadsheetDocument;
import com._1c.g5.v8.dt.moxel.content.ContentPackage;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.converter.IConverterManager;
import com.e1c.langtool.converter.IConverterService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.TranslationPreferences;
import com.e1c.langtool.v8.dt.internal.moxel.MoxelPlugin;
import com.e1c.langtool.v8.dt.moxel.MoxelUtils;
import com.e1c.langtool.v8.dt.moxel.settings.MoxelFeatureSettings;
import com.e1c.langtool.v8.dt.sync.BmObjectCopier;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MoxelCopier
extends BmObjectCopier {
    @Inject
    private transient ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private TranslationPreferences preferences;
    @Inject
    private IConverterService converterService;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    private final transient EObject sourceRoot;
    private final transient IFile sourceFile;
    private String translatedTopObjectFqn;

    public MoxelCopier(IProject project, IBmPlatformTransaction transaction, EObject sourceRoot, IFile sourceFile, IProjectTranslationProvider translationProvider, IBmNamespace targetNamespace, Version runtimeVersion) {
        super(project, transaction, sourceRoot, translationProvider, targetNamespace, runtimeVersion);
        this.sourceRoot = sourceRoot;
        this.sourceFile = sourceFile;
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        super.copyContainment(eReference, eObject, copyEObject);
        if (eObject.eIsSet((EStructuralFeature)eReference) && ContentPackage.Literals.LOCAL_STRING__CONTENT.equals(eReference) && this.translationProvider.getProject().isChangeDefaultLanguage()) {
            EMap localStringsMap = (EMap)copyEObject.eGet((EStructuralFeature)eReference);
            String sourceLanguageCode = this.translationProvider.getProject().getSourceProject().getDefaultLanguage().getLanguageCode();
            String lsContent = (String)((EMap)eObject.eGet((EStructuralFeature)eReference)).get((Object)sourceLanguageCode);
            Map<String, String> params = MoxelUtils.getParamsMapFromNls(lsContent);
            if (params.isEmpty()) {
                return;
            }
            HashMap paramTranslations = Maps.newHashMap();
            FeatureKey featureKey = this.featureKeyProvider.getKey(eObject);
            if (featureKey == null) {
                MoxelPlugin.log(MoxelPlugin.createWarningStatus(MessageFormat.format("Cannot generate FeatureKey for object: {0} in file: {1}", EcoreUtil.getURI((EObject)eObject), this.sourceFile.getFullPath())));
                return;
            }
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String param = entry.getKey();
                if (StringUtils.isNullOrEmpty((String)param)) continue;
                String[] paramParts = param.split("\\.");
                CharSequence[] translations = new String[paramParts.length];
                System.arraycopy(paramParts, 0, translations, 0, paramParts.length);
                int i = 0;
                while (i < paramParts.length) {
                    IConverterManager manager;
                    TranslateLanguage lang;
                    IProject project;
                    String paramPart = paramParts[i];
                    FeatureKey paramKey = featureKey.append((FeatureKey)SegmentFeatureKey.create((String[])new String[]{paramPart, MoxelFeatureSettings.Literals.LOCAL_STRING__PARAM.getName()}));
                    ContextTranslationKeyImpl paramValue = new ContextTranslationKeyImpl(this.sourceFile, paramKey, MoxelFeatureSettings.Literals.LOCAL_STRING__PARAM, paramPart);
                    String translation = this.translationProvider.getTranslation(eObject, (ContextTranslationKey)paramValue, language);
                    if (StringUtils.isNotEmpty((String)translation)) {
                        translations[i] = translation;
                    }
                    if (this.preferences.getTranslationProperties(project = this.translationProvider.getProject().getSourceProject().getProject()).isEnablePersistentKeyMappingCache() && (lang = (manager = this.converterService.getManager(project)).getLanguage()).getLanguageCode().equals(language.getLanguageCode())) {
                        IPath path = this.sourceFile.getFullPath();
                        manager.updateStringLiteralParams(path.makeRelativeTo(project.getFullPath()), paramPart, translation);
                    }
                    ++i;
                }
                paramTranslations.put(param, entry.getValue().replace(param, String.join((CharSequence)".", translations)));
            }
            this.replaceParamsInNlsStrings((EMap<String, String>)localStringsMap, params, paramTranslations);
        }
        if (copyEObject instanceof SpreadsheetDocument) {
            SpreadsheetDocument spreadsheetDocument = (SpreadsheetDocument)copyEObject;
            TranslateLanguage defaultLanguage = this.translationProvider.getProject().getDefaultLanguage();
            IV8Project v8Project = this.v8ProjectManager.getProject(this.translationProvider.getProject().getProjectName());
            Collection projectLanguages = v8Project.getLanguages();
            ArrayList<String> validLanguages = new ArrayList<String>();
            for (Language lang : projectLanguages) {
                validLanguages.add(lang.getLanguageCode());
            }
            Iterator iterator = spreadsheetDocument.getLanguageSettings().getLanguages().iterator();
            HashSet<String> existingLanguageCodes = new HashSet<String>();
            while (iterator.hasNext()) {
                LanguageInfo languageInfo = (LanguageInfo)iterator.next();
                if (!validLanguages.contains(languageInfo.getLanguageId())) {
                    iterator.remove();
                    continue;
                }
                existingLanguageCodes.add(languageInfo.getLanguageId());
            }
            ScriptVariant scriptVariant = this.translationProvider.getProject().getScriptVariant();
            boolean isRu = scriptVariant.equals((Object)ScriptVariant.RUSSIAN);
            for (Language lang : projectLanguages) {
                LanguageInfo existingLanguageInfo = null;
                for (LanguageInfo languageInfo : spreadsheetDocument.getLanguageSettings().getLanguages()) {
                    if (!languageInfo.getLanguageId().equals(lang.getLanguageCode())) continue;
                    existingLanguageInfo = languageInfo;
                    break;
                }
                String translatedName = (String)lang.getSynonym().get((Object)defaultLanguage.getLanguageCode());
                if (translatedName == null || translatedName.isEmpty()) {
                    translatedName = lang.getName();
                }
                if (existingLanguageInfo != null) {
                    existingLanguageInfo.setLanguageCode(translatedName);
                    existingLanguageInfo.setDescription(translatedName);
                    continue;
                }
                LanguageInfo newLanguageInfo = MoxelFactory.eINSTANCE.createLanguageInfo();
                newLanguageInfo.setLanguageCode(translatedName);
                newLanguageInfo.setLanguageId(lang.getLanguageCode());
                newLanguageInfo.setDescription(translatedName);
                spreadsheetDocument.getLanguageSettings().getLanguages().add((Object)newLanguageInfo);
            }
            spreadsheetDocument.getLanguageSettings().setCurrentLanguage(isRu ? "ru" : "en");
            spreadsheetDocument.getLanguageSettings().setDefaultLanguage(defaultLanguage.getLanguageCode());
        }
    }

    protected String getTranslatedTopObjectFqn() {
        if (this.translatedTopObjectFqn == null) {
            this.translatedTopObjectFqn = this.fqnGenerator.generateFqn(this.sourceRoot, this.translationProvider);
        }
        return this.translatedTopObjectFqn;
    }

    public void setTranslatedTopObjectFqn(String translatedTopObjectFqn) {
        this.translatedTopObjectFqn = translatedTopObjectFqn;
    }

    private void replaceParamsInNlsStrings(EMap<String, String> localStringsMap, Map<String, String> params, Map<String, String> paramTranslations) {
        if (paramTranslations.isEmpty()) {
            return;
        }
        for (Map.Entry entry : localStringsMap) {
            for (Map.Entry<String, String> translationEntry : paramTranslations.entrySet()) {
                String source = params.get(translationEntry.getKey());
                entry.setValue(((String)entry.getValue()).replace(source, translationEntry.getValue()));
            }
        }
    }
}

