/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.events;

import com._1c.g5.v8.dt.bp.scheme.model.EventHandler;
import com._1c.g5.v8.dt.bp.scheme.model.GraphicalSchemeItem;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleType;
import com._1c.g5.v8.dt.bsl.model.Procedure;
import com._1c.g5.v8.dt.bsl.resource.BslEventsService;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bp.scheme.settings.SchemeFeatureSettings;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class BpSchemaComputedNameProvider
implements IComputedStringFeatureTranslationProvider {
    private static final String BUSINESS_PRECESS = "BusinessProcess";
    private static final String BUSINESS_PRECESSES = "BusinessProcesses";
    @Inject
    private BslEventsService bslEventsService;

    public boolean isSupported(EObject object) {
        if (object instanceof Procedure) {
            Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
            if (module == null) {
                return false;
            }
            ModuleType moduleType = module.getModuleType();
            if (moduleType.equals((Object)ModuleType.OBJECT_MODULE)) {
                String uri = EcoreUtil.getURI((EObject)module).toPlatformString(true);
                return uri.contains(BUSINESS_PRECESS) || uri.contains(BUSINESS_PRECESSES);
            }
        }
        return false;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return false;
        }
        String name = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)name)) {
            return false;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        Map eventHandlers = this.bslEventsService.getEventHandlersContainer(module);
        List handlers = (List)eventHandlers.get(new CaseInsensitiveString(name));
        return handlers != null && !handlers.isEmpty();
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!translationProvider.getProject().isChangeDefaultLanguage()) {
            return null;
        }
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return null;
        }
        String name = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)name)) {
            return null;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        Map handlerContainers = this.bslEventsService.getEventHandlersContainer(module);
        List containers = (List)handlerContainers.get(new CaseInsensitiveString(name));
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        for (EObject container : containers) {
            String translation = null;
            if (container instanceof GraphicalSchemeItem) {
                GraphicalSchemeItem item = (GraphicalSchemeItem)container;
                Optional<EventHandler> eventHandler = item.getEventHandlers().stream().filter(h -> name.equals(h.getName())).findFirst();
                if (eventHandler.isPresent()) {
                    translation = translationProvider.getTranslation((EObject)eventHandler.get(), SchemeFeatureSettings.Literals.EVENT_HANDLER__NAME, language);
                }
            } else if (container instanceof EventHandler) {
                translation = translationProvider.getTranslation(container, SchemeFeatureSettings.Literals.EVENT_HANDLER__NAME, language);
            }
            if (!StringUtils.isNotEmpty(translation)) continue;
            return translation;
        }
        return null;
    }
}

