/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.bsl.events;

import com._1c.g5.v8.dt.bsl.model.FormalParam;
import com._1c.g5.v8.dt.bsl.model.Method;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.bsl.model.ModuleType;
import com._1c.g5.v8.dt.bsl.model.Procedure;
import com._1c.g5.v8.dt.bsl.resource.BslEventsService;
import com._1c.g5.v8.dt.form.model.EventHandler;
import com._1c.g5.v8.dt.form.model.EventHandlerContainer;
import com._1c.g5.v8.dt.form.model.FormCommand;
import com._1c.g5.v8.dt.form.model.FormCommandHandlerContainer;
import com._1c.g5.v8.dt.lcore.util.CaseInsensitiveString;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.bsl.events.internal.BslEnventsPlugin;
import com.e1c.langtool.v8.dt.form.settings.FormFeatureSettings;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class FormComputedNameProvider
implements IComputedStringFeatureTranslationProvider {
    private static final String EVENT_PARAM_ITEM_NAME = "Item";
    private static final String EVENT_PARAM_ITEM_NAME_RU = "\u042d\u043b\u0435\u043c\u0435\u043d\u0442";
    @Inject
    private BslEventsService bslEventsService;

    public boolean isSupported(EObject object) {
        if (object instanceof Procedure || object instanceof FormalParam && object.eContainer() instanceof Method && ((Method)object.eContainer()).getFormalParams().indexOf((Object)object) == 0) {
            Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
            if (module == null) {
                return false;
            }
            ModuleType moduleType = module.getModuleType();
            if (moduleType.equals((Object)ModuleType.FORM_MODULE)) {
                return true;
            }
        }
        return false;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        String methodName;
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return false;
        }
        if (object instanceof Procedure) {
            methodName = (String)object.eGet(stringFeature.getEFeature());
        } else if (object instanceof FormalParam && (((FormalParam)object).getName().equalsIgnoreCase(EVENT_PARAM_ITEM_NAME_RU) || ((FormalParam)object).getName().equalsIgnoreCase(EVENT_PARAM_ITEM_NAME))) {
            methodName = (String)object.eContainer().eGet(stringFeature.getEFeature());
        } else {
            return false;
        }
        if (StringUtils.isNullOrEmpty((String)methodName)) {
            return false;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        try {
            Map eventHandlers = this.bslEventsService.getEventHandlersContainer(module);
            List handlers = (List)eventHandlers.get(new CaseInsensitiveString(methodName));
            return handlers != null && !handlers.isEmpty();
        }
        catch (Exception e) {
            String message = MessageFormat.format("Error while get module handlers: {0}", EcoreUtil.getURI((EObject)module));
            IStatus status = BslEnventsPlugin.createErrorStatus(message, e);
            BslEnventsPlugin.log(status);
            return false;
        }
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!stringFeature.equals(McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME)) {
            return null;
        }
        if (!(object instanceof Procedure)) {
            if (object instanceof FormalParam && (((FormalParam)object).getName().equalsIgnoreCase(EVENT_PARAM_ITEM_NAME_RU) || ((FormalParam)object).getName().equalsIgnoreCase(EVENT_PARAM_ITEM_NAME))) {
                if (translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN)) {
                    return EVENT_PARAM_ITEM_NAME_RU;
                }
                return EVENT_PARAM_ITEM_NAME;
            }
            return null;
        }
        String methodName = (String)object.eGet(stringFeature.getEFeature());
        if (StringUtils.isNullOrEmpty((String)methodName)) {
            return null;
        }
        Module module = (Module)EcoreUtil2.getContainerOfType((EObject)object, Module.class);
        Map handlerContainers = this.bslEventsService.getEventHandlersContainer(module);
        List containers = (List)handlerContainers.get(new CaseInsensitiveString(methodName));
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        for (EObject container : containers) {
            String translation = null;
            if (container instanceof FormCommand && ((FormCommand)container).getAction() instanceof FormCommandHandlerContainer) {
                commandHandlerContainer = (FormCommandHandlerContainer)((FormCommand)container).getAction();
                translation = translationProvider.getTranslation((EObject)commandHandlerContainer.getHandler(), FormFeatureSettings.Literals.COMMAND_HANDLER__NAME, language);
            } else if (container instanceof FormCommandHandlerContainer) {
                commandHandlerContainer = (FormCommandHandlerContainer)container;
                translation = translationProvider.getTranslation((EObject)commandHandlerContainer.getHandler(), FormFeatureSettings.Literals.COMMAND_HANDLER__NAME, language);
            } else if (container instanceof EventHandlerContainer) {
                for (EventHandler eventHandler : ((EventHandlerContainer)container).getHandlers()) {
                    if (!eventHandler.getName().equals(methodName) || !StringUtils.isNotEmpty((String)(translation = translationProvider.getTranslation((EObject)eventHandler, FormFeatureSettings.Literals.EVENT_HANDLER__NAME, language)))) continue;
                    return translation;
                }
            } else if (container instanceof EventHandler) {
                translation = translationProvider.getTranslation(container, FormFeatureSettings.Literals.EVENT_HANDLER__NAME, language);
            }
            if (!StringUtils.isNotEmpty(translation)) continue;
            return translation;
        }
        return null;
    }
}

