/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.rights.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.rights.model.RestrictionTemplate;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.right.ql.translator.TemplateUtil;
import com.e1c.langtool.v8.dt.right.templates.TemplateNameParameterProvider;
import com.e1c.langtool.v8.dt.right.templates.settings.RightTemplateFeatureSettings;
import com.e1c.langtool.v8.dt.right.templates.translator.TemplateNameParameterTranslationProvider;
import com.e1c.langtool.v8.dt.rights.settings.RightsFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;

public class TemplateNameTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private TemplateNameParameterProvider templateNameParameterProvider;
    @Inject
    private TemplateNameParameterTranslationProvider templateNameParameterTranslationProvider;

    public boolean isSupported(EObject object) {
        return object instanceof RestrictionTemplate;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!stringFeature.equals(RightsFeatureSettings.Literals.RESTRICTION_TEMPLATE__NAME)) {
            return false;
        }
        RestrictionTemplate template = (RestrictionTemplate)object;
        String name = template.getName();
        return name != null && (this.hasParameters(template) || TemplateUtil.hasPoundBracket((String)name));
    }

    private boolean hasParameters(RestrictionTemplate template) {
        return !this.templateNameParameterProvider.getParameters(template).isEmpty();
    }

    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        if (!stringFeature.equals(RightsFeatureSettings.Literals.RESTRICTION_TEMPLATE__NAME)) {
            return null;
        }
        RestrictionTemplate template = (RestrictionTemplate)object;
        String content = template.getName();
        List parameters = this.templateNameParameterProvider.getParameters(template);
        if (content != null && (!parameters.isEmpty() || TemplateUtil.hasPoundBracket((String)content))) {
            Pair name = TemplateUtil.getName((String)content);
            IFile file = this.resourceLookup.getPlatformResource((EObject)template);
            String nameTranslation = this.getTranslation(template, (String)name.getKey(), file, translationProvider, language);
            StringBuilder sb = new StringBuilder();
            int current = 0;
            if ((Integer)name.getValue() > 0) {
                sb.append(content.substring(0, (Integer)name.getValue()));
                current = (Integer)name.getValue();
            }
            sb.append(nameTranslation);
            current += ((String)name.getKey()).length();
            if (!parameters.isEmpty()) {
                Map paramTranslation = this.templateNameParameterTranslationProvider.getParameters(template, translationProvider);
                for (String param : parameters) {
                    int startPos = content.indexOf(param, current);
                    sb.append(content.substring(current, startPos));
                    sb.append((String)paramTranslation.get(param));
                    current = startPos + param.length();
                }
            }
            if (current < content.length()) {
                sb.append(content.substring(current));
            }
            return sb.toString();
        }
        return null;
    }

    private String getTranslation(RestrictionTemplate template, String name, IFile file, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)template, RightTemplateFeatureSettings.Literals.RESTRICTION_TEMPLATE__EXTRACTED_NAME);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(file, featureKey, RightTemplateFeatureSettings.Literals.RESTRICTION_TEMPLATE__PARAMETER_NAME, name);
        String translation = translationProvider.getTranslation((EObject)template, (ContextTranslationKey)contextKey, language);
        if (StringUtils.isNullOrEmpty((String)translation)) {
            translation = name;
        }
        return translation;
    }
}

