/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.resourcestorage.IV8FileNameConverter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractV8FileNameConverter
implements IV8FileNameConverter {
    protected static final String FILE_EXTENSION_TRANS = "trans";
    protected static final String FILE_EXTENSION_LSTR = "lstr";
    protected static final String FILE_EXTENSION_NSTR = "nstr";
    protected static final String FILE_EXTENSION_DICT = "dict";
    protected static final String FILE_EXTENSION_LSDICT = "lsdict";
    protected static final String FILE_NAME_SEGMENT_SPLITTER = "_";
    protected static final String SOURCE_FOLDER = "src";
    @Inject
    protected ITranslatingProjectManager translatingProjectManager;

    @Override
    public IFile getTranslationFile(IFile v8File, boolean isLocalizable, TranslateLanguage language) {
        IPath newPath = this.getTranslationPath(v8File.getFullPath(), isLocalizable, language);
        if (newPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
    }

    @Override
    public IFile getTranslationFile(IPath v8Path, boolean isLocalizable, TranslateLanguage language) {
        IPath newPath = this.getTranslationPath(v8Path, isLocalizable, language);
        if (newPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(newPath);
    }

    @Override
    public IPath getTranslationPath(IFile v8File, boolean isLocalizable, TranslateLanguage language) {
        return this.getTranslationPath(v8File.getFullPath(), isLocalizable, language);
    }

    @Override
    public Set<IFile> getV8File(IFile translationFile) {
        return this.getV8File(translationFile.getFullPath());
    }

    @Override
    public Set<IFile> getV8File(IPath translationPath) {
        Set<IPath> paths = this.getV8Path(translationPath);
        if (paths == null) {
            return Collections.emptySet();
        }
        HashSet files = Sets.newHashSet();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath path : paths) {
            files.add(root.getFile(path));
        }
        return files;
    }

    @Override
    public Set<IPath> getV8Path(IPath translationPath) {
        return Collections.emptySet();
    }

    @Override
    public Set<IPath> getV8Path(IFile translationFile) {
        return this.getV8Path(translationFile.getFullPath());
    }

    @Override
    public boolean isInterface(IPath translationPath) {
        Assert.isLegal((translationPath != null ? 1 : 0) != 0, (String)"Argument 'Path' may not be null");
        Assert.isLegal((!translationPath.isEmpty() ? 1 : 0) != 0, (String)"Argument 'Path' may not be empty");
        FileName fileName = new FileName(translationPath.lastSegment());
        Assert.isLegal((fileName.hasLanguageCode() && (fileName.isInterface() || fileName.isModel()) ? 1 : 0) != 0, (String)"Argument 'Path' is not a Translation file");
        return fileName.isInterface();
    }

    @Override
    public boolean isInterface(IFile translationFile) {
        return this.isInterface(translationFile.getFullPath());
    }

    @Override
    public TranslateLanguage getLanguage(IPath translationPath) {
        if (translationPath.segmentCount() < 2) {
            return null;
        }
        String languageCode = this.getLanguageCode(translationPath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(translationPath.segment(0));
        Collection languages = this.translatingProjectManager.getLanguagesForExternalProject(project);
        return languages.stream().filter(l -> l.getLanguageCode().equals(languageCode)).findFirst().orElse(null);
    }

    public String getLanguageCode(IPath translationPath) {
        Assert.isLegal((translationPath != null ? 1 : 0) != 0, (String)"Argument 'Path' may not be null");
        if (translationPath.isEmpty()) {
            return null;
        }
        switch (translationPath.getFileExtension()) {
            case "lsdict": 
            case "dict": 
            case "lstr": 
            case "nstr": 
            case "trans": {
                FileName fileName = new FileName(translationPath.lastSegment());
                if (fileName.hasLanguageCode()) {
                    return fileName.languageCode;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public TranslateLanguage getLanguage(IFile translationFile) {
        return this.getLanguage(translationFile.getFullPath());
    }

    @Override
    public boolean isTranslation(IPath translationPath) {
        if (translationPath == null || translationPath.isEmpty()) {
            return false;
        }
        switch (translationPath.getFileExtension()) {
            case "lsdict": 
            case "dict": 
            case "lstr": 
            case "nstr": 
            case "trans": {
                if (!AbstractV8FileNameConverter.hasRootFolder(translationPath)) {
                    return false;
                }
                FileName fileName = new FileName(translationPath.lastSegment());
                return fileName.hasSegment() && fileName.hasLanguageCode() && (fileName.isModel() || fileName.isInterface());
            }
        }
        return false;
    }

    @Override
    public boolean isTranslation(IFile translationFile) {
        return translationFile != null && this.isTranslation(translationFile.getFullPath());
    }

    @Override
    public String getSegment(IPath translationPath) {
        if (translationPath == null || translationPath.isEmpty()) {
            return null;
        }
        if (!(FILE_EXTENSION_DICT.equals(translationPath.getFileExtension()) || FILE_EXTENSION_LSDICT.equals(translationPath.getFileExtension()) || FILE_EXTENSION_LSTR.equals(translationPath.getFileExtension()) || FILE_EXTENSION_NSTR.equals(translationPath.getFileExtension()) || FILE_EXTENSION_TRANS.equals(translationPath.getFileExtension()))) {
            return null;
        }
        if (!AbstractV8FileNameConverter.hasRootFolder(translationPath)) {
            return null;
        }
        FileName fileName = new FileName(translationPath.lastSegment());
        if (fileName.hasSegment() && fileName.hasLanguageCode() && (fileName.isModel() || fileName.isInterface())) {
            return fileName.segment;
        }
        return null;
    }

    @Override
    public String getSegment(IFile translationFile) {
        if (translationFile == null) {
            return null;
        }
        return this.getSegment(translationFile.getFullPath());
    }

    protected static boolean hasRootFolder(IPath path) {
        int i = 0;
        while (i < path.segmentCount()) {
            String segment = path.segment(i);
            if (SOURCE_FOLDER.equals(segment)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static class FileName {
        String segment;
        String languageCode;
        String fileExtension;

        public FileName(String fileName) {
            String name = fileName;
            int index = name.indexOf(46);
            if (index >= 0) {
                name = name.substring(0, index);
                this.fileExtension = fileName.substring(index + 1);
            } else {
                this.fileExtension = "";
            }
            String[] segments = name.split(AbstractV8FileNameConverter.FILE_NAME_SEGMENT_SPLITTER);
            if (segments.length > 1) {
                CharSequence[] segmentList = new String[segments.length - 1];
                System.arraycopy(segments, 0, segmentList, 0, segments.length - 1);
                this.segment = String.join((CharSequence)AbstractV8FileNameConverter.FILE_NAME_SEGMENT_SPLITTER, segmentList);
                this.languageCode = segments[segments.length - 1];
            }
        }

        public FileName(String segment, String languageCode, String fileExtension) {
            this.segment = segment;
            this.languageCode = languageCode;
            this.fileExtension = fileExtension;
        }

        public boolean hasSegment() {
            return !Strings.isNullOrEmpty((String)this.segment);
        }

        public boolean isModel() {
            return AbstractV8FileNameConverter.FILE_EXTENSION_TRANS.equals(this.fileExtension) || AbstractV8FileNameConverter.FILE_EXTENSION_DICT.equals(this.fileExtension);
        }

        public boolean isInterface() {
            return AbstractV8FileNameConverter.FILE_EXTENSION_NSTR.equals(this.fileExtension) || AbstractV8FileNameConverter.FILE_EXTENSION_LSTR.equals(this.fileExtension) || AbstractV8FileNameConverter.FILE_EXTENSION_LSDICT.equals(this.fileExtension);
        }

        public boolean hasLanguageCode() {
            return !Strings.isNullOrEmpty((String)this.languageCode);
        }

        public String toString() {
            return this.segment + AbstractV8FileNameConverter.FILE_NAME_SEGMENT_SPLITTER + this.languageCode;
        }
    }
}

