/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.resourcestorage;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.resourcestorage.AbstractV8FileNameConverter;
import com.google.common.base.Strings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ProjectCommonFileNameConverter
extends AbstractV8FileNameConverter {
    @Override
    public IPath getTranslationPath(IPath v8Path, boolean isLocalizable, TranslateLanguage language) {
        Assert.isLegal((v8Path != null ? 1 : 0) != 0, (String)"Argument 'v8Path' may not be null");
        Assert.isLegal((language != null ? 1 : 0) != 0, (String)"Argument 'language' may not be null");
        Assert.isLegal((!Strings.isNullOrEmpty((String)language.getLanguageCode()) ? 1 : 0) != 0, (String)"language code of the language argument may not be null or empty");
        if (!ProjectCommonFileNameConverter.hasRootFolder(v8Path)) {
            return null;
        }
        String translationFileExtension = isLocalizable ? "lsdict" : "dict";
        AbstractV8FileNameConverter.FileName fileName = new AbstractV8FileNameConverter.FileName(v8Path.removeFileExtension().lastSegment(), language.getLanguageCode(), translationFileExtension);
        int sourceIndex = -1;
        int i = 0;
        while (i < v8Path.segmentCount()) {
            String segment = v8Path.segment(i);
            if ("src".equals(segment)) {
                sourceIndex = i;
                break;
            }
            ++i;
        }
        int segmentsToRemove = sourceIndex >= 0 ? v8Path.segmentCount() - sourceIndex - 1 : 1;
        IPath newPath = v8Path.removeLastSegments(segmentsToRemove).append(fileName.toString()).addFileExtension(translationFileExtension);
        IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(v8Path.segment(0));
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(parentProject);
        IProject holderProject = this.translatingProjectManager.getLanguageProject(translatingProject, language);
        if (holderProject != null) {
            return holderProject.getFullPath().append(newPath.removeFirstSegments(1));
        }
        return null;
    }
}

